/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public final class TypeUtil {
    private static Map<Class<?>, Class<?>> primitiveToWrapperMap = new HashMap();

    public static boolean isAssignable(Class<?> cls, @Nullable Object object) {
        if (object == null && !cls.isPrimitive()) {
            return true;
        }
        if (TypeUtil.toWrapper(cls).isInstance(object)) {
            return true;
        }
        if (object instanceof Double) {
            return TypeUtil.cast((Double)object, TypeUtil.toWrapper(cls)).isPresent();
        }
        return false;
    }

    public static Object toCompatibleType(@Nullable Object object, Class<?> cls) {
        Optional<Object> result;
        if (object == null && !cls.isPrimitive()) {
            return null;
        }
        if (TypeUtil.toWrapper(cls).isInstance(object)) {
            return object;
        }
        if (object instanceof Double && (result = TypeUtil.cast((Double)object, TypeUtil.toWrapper(cls))).isPresent()) {
            return result.get();
        }
        throw new IllegalArgumentException("Failed to convert the object to the compatible type: " + object + "; " + cls);
    }

    private TypeUtil() {
    }

    private static Optional<Object> cast(Double value, Class<?> cls) {
        boolean isInteger;
        Number result = null;
        boolean bl = isInteger = value.compareTo(Math.floor(value)) == 0;
        if (cls.equals(Double.class) || cls.equals(Number.class) || cls.equals(Object.class)) {
            result = value;
        } else if (cls.equals(Float.class)) {
            if (Double.compare(value, 3.4028234663852886E38) <= 0 && Double.compare(value, -3.4028234663852886E38) >= 0 && Double.compare(value, value.floatValue()) == 0) {
                result = Float.valueOf(value.floatValue());
            }
        } else if (isInteger) {
            if (cls.equals(Long.class)) {
                if (value >= -9.223372036854776E18 && value <= 9.223372036854776E18) {
                    result = value.longValue();
                }
            } else if (cls.equals(Integer.class)) {
                if (value >= -2.147483648E9 && value <= 2.147483647E9) {
                    result = value.intValue();
                }
            } else if (cls.equals(Short.class)) {
                if (value >= -32768.0 && value <= 32767.0) {
                    result = value.shortValue();
                }
            } else if (cls.equals(Byte.class) && value >= -128.0 && value <= 127.0) {
                result = value.byteValue();
            }
        }
        return Optional.ofNullable(result);
    }

    private static Class<?> toWrapper(Class<?> cls) {
        if (!cls.isPrimitive()) {
            return cls;
        }
        return primitiveToWrapperMap.get(cls);
    }

    static {
        primitiveToWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveToWrapperMap.put(Long.TYPE, Long.class);
        primitiveToWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveToWrapperMap.put(Character.TYPE, Character.class);
        primitiveToWrapperMap.put(Float.TYPE, Float.class);
        primitiveToWrapperMap.put(Double.TYPE, Double.class);
        primitiveToWrapperMap.put(Short.TYPE, Short.class);
        primitiveToWrapperMap.put(Void.TYPE, Void.class);
    }
}

