/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.util;

import com.teamdev.jxbrowser.internal.util.ReflectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class ReflectionUtil {
    public static Method getMethod(Class<?> cls, String name, Class ... args) {
        try {
            return cls.getDeclaredMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    public static Method getMethod(String className, String name, Class ... args) {
        try {
            Class<?> cls = Class.forName(className);
            return cls.getDeclaredMethod(name, args);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    public static Constructor<?> getConstructor(String className, Class ... args) {
        try {
            Class<?> cls = Class.forName(className);
            return cls.getConstructor(args);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    public static Constructor<?> getConstructor(Class<?> cls, Class ... args) {
        try {
            return cls.getConstructor(args);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    public static Optional<Method> findMethod(String className, String name, Class ... args) {
        try {
            return Optional.of(ReflectionUtil.getMethod(className, name, args));
        }
        catch (ReflectionException e) {
            return Optional.empty();
        }
    }

    public static <T> T newInstance(Constructor constructor, Object ... args) {
        try {
            Object result = constructor.newInstance(args);
            return result;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    public static <T> T invoke(@Nullable Object instance, Method method, Object ... args) {
        try {
            Object result = method.invoke(instance, args);
            return (T)result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    public static Optional<Method> findPublicMethodByName(Class<?> cls, String name) {
        ArrayList<Method> result = new ArrayList<Method>();
        ReflectionUtil.findPublicMethodsByName(cls, name, result);
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(result.get(0));
    }

    public static Optional<Class<?>> findDeclaredClass(Class<?> cls, String name) {
        Class<?>[] declaredClasses;
        for (Class<?> declaredClass : declaredClasses = cls.getDeclaredClasses()) {
            if (!declaredClass.getSimpleName().equals(name)) continue;
            return Optional.of(declaredClass);
        }
        return Optional.empty();
    }

    private ReflectionUtil() {
    }

    private static void findPublicMethodsByName(Class<?> cls, String name, List<Method> methods) {
        Method[] allMethods;
        for (Method method : allMethods = cls.getDeclaredMethods()) {
            if (!method.getName().equals(name) || !Modifier.isPublic(method.getModifiers())) continue;
            methods.add(method);
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            ReflectionUtil.findPublicMethodsByName(superclass, name, methods);
        }
    }

    public static Set<Method> findPublicMethods(Class<?> cls, Predicate<Method> predicate) {
        return Stream.of(cls.getMethods()).filter(predicate).collect(Collectors.toSet());
    }
}

