/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.util;

import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class Preconditions {
    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public static <T> T checkNotNull(@Nullable T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(@Nullable T reference, String errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage);
        }
        return reference;
    }

    public static void checkNotNullEmptyOrBlank(String reference) {
        Preconditions.checkNotNull(reference);
        if (reference.isEmpty() || reference.trim().isEmpty()) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkNotNullEmptyOrBlank(String reference, String errorMessage) {
        Preconditions.checkNotNull(reference, errorMessage);
        if (reference.isEmpty() || reference.trim().isEmpty()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @SafeVarargs
    public static <T> void checkNotNull(T ... array) {
        if (array == null) {
            throw new NullPointerException();
        }
        Stream.of(array).forEach(Preconditions::checkNotNull);
    }

    public static void checkNotNullEmptyOrBlank(String ... array) {
        Preconditions.checkNotNull(array);
        Stream.of(array).forEach(Preconditions::checkNotNullEmptyOrBlank);
    }

    private Preconditions() {
    }
}

