/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.util;

import com.teamdev.jxbrowser.ui.Color;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;

public final class GeometryUtil {
    public static Rect scaleDown(Rect rect, double scaleFactor) {
        Point origin = rect.origin();
        Size size = rect.size();
        return Rect.of(GeometryUtil.scaleDown(origin, scaleFactor), Size.of((int)((double)size.width() / scaleFactor), (int)((double)size.height() / scaleFactor)));
    }

    public static Rect scaleUp(Rect rect, double scaleFactor) {
        Point origin = rect.origin();
        Size size = rect.size();
        return Rect.of(GeometryUtil.scaleUp(origin, scaleFactor), Size.of((int)((double)size.width() * scaleFactor), (int)((double)size.height() * scaleFactor)));
    }

    public static Point scaleDown(Point point, double scaleFactor) {
        return Point.of((int)((double)point.x() / scaleFactor), (int)((double)point.y() / scaleFactor));
    }

    public static Point scaleUp(Point point, double scaleFactor) {
        return Point.of((int)((double)point.x() * scaleFactor), (int)((double)point.y() * scaleFactor));
    }

    public static Rect makeRect(double x, double y, double width, double height) {
        return Rect.of(GeometryUtil.makePoint(x, y), Size.of((int)width, (int)height));
    }

    public static Point makePoint(double x, double y) {
        return Point.of((int)x, (int)y);
    }

    public static Color makeColor(float red, float green, float blue, float alpha) {
        return Color.newBuilder().red(red).green(green).blue(blue).alpha(alpha).build();
    }

    public static boolean isEmpty(Size size) {
        return size.width() == 0 && size.height() == 0;
    }

    private GeometryUtil() {
    }
}

