/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.transport;

import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.event.internal.ObservableHelper;
import com.teamdev.jxbrowser.internal.rpc.ConnectionId;
import com.teamdev.jxbrowser.internal.rpc.RpcRequest;
import com.teamdev.jxbrowser.internal.rpc.RpcResponse;
import com.teamdev.jxbrowser.internal.rpc.event.ConnectionClosed;
import com.teamdev.jxbrowser.internal.rpc.event.ConnectionEvent;
import com.teamdev.jxbrowser.internal.rpc.stream.Stream;
import com.teamdev.jxbrowser.internal.rpc.stream.StreamObserver;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcThread;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemoryChannel;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import javax.annotation.ParametersAreNonnullByDefault;

public final class SharedMemoryConnection
implements Connection {
    private final ConnectionId id;
    private final SharedMemoryChannel channel;
    private final ObservableHelper<ConnectionEvent> observable;

    SharedMemoryConnection(ConnectionId id, SharedMemoryChannel channel) {
        Preconditions.checkNotNull(channel);
        this.id = id;
        this.channel = channel;
        this.observable = new ObservableHelper();
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.channel.close();
        this.observable.notifyObservers(new ConnectionClosed(this));
    }

    @Override
    public boolean isClosed() {
        return this.channel.isClosed();
    }

    @Override
    @ParametersAreNonnullByDefault
    public <E extends ConnectionEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.observable.on(eventClass, observer);
    }

    @Override
    public ConnectionId id() {
        return this.id;
    }

    @Override
    public void send(RpcRequest request, RpcCallback<RpcResponse> callback) {
        this.channel.send(request, callback);
    }

    @Override
    public Stream<RpcRequest> openStream(RpcRequest request, StreamObserver<RpcResponse> observer) {
        return this.channel.openStream(request, observer);
    }

    @Override
    public RpcThread rpcThread() {
        return this.channel.getThread();
    }
}

