/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.transport;

import com.teamdev.jxbrowser.Closeable;
import com.teamdev.jxbrowser.deps.com.google.protobuf.InvalidProtocolBufferException;
import com.teamdev.jxbrowser.internal.rpc.RpcRequest;
import com.teamdev.jxbrowser.internal.rpc.RpcRequestId;
import com.teamdev.jxbrowser.internal.rpc.RpcResponse;
import com.teamdev.jxbrowser.internal.rpc.TextFormat;
import com.teamdev.jxbrowser.internal.rpc.stream.Stream;
import com.teamdev.jxbrowser.internal.rpc.stream.StreamObserver;
import com.teamdev.jxbrowser.internal.rpc.transport.CommonThreadResponseConsumer;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcThread;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemory;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class SharedMemoryChannel
implements Closeable {
    private final RpcThread thread;
    private final SharedMemory memory;
    private final Map<RpcRequestId, StreamObserver<RpcResponse>> requestMap;

    SharedMemoryChannel(RpcThread thread, SharedMemory memory) {
        Preconditions.checkNotNull(thread);
        Preconditions.checkNotNull(memory);
        this.thread = thread;
        this.memory = memory;
        this.requestMap = new ConcurrentHashMap<RpcRequestId, StreamObserver<RpcResponse>>();
        memory.setCallback(data -> {
            try {
                RpcResponse response = RpcResponse.parseFrom(data);
                Logger.debug("Reading RPC response... " + TextFormat.shortDebugString(response));
                RpcRequestId requestId = response.getRequestId();
                if (this.requestMap.containsKey(requestId)) {
                    StreamObserver<RpcResponse> observer = response.hasStreamData() ? this.requestMap.get(requestId) : this.requestMap.remove(requestId);
                    Logger.debug("Calling RPC response observer... " + TextFormat.shortDebugString(response));
                    try {
                        observer.onNext(response);
                        Logger.debug("Calling RPC response observer... [OK] " + TextFormat.shortDebugString(response));
                    }
                    catch (Exception e) {
                        Logger.error("Calling RPC response observer... [FAIL] " + TextFormat.shortDebugString(response), e);
                    }
                } else {
                    Logger.debug("No callback found for RPC response: " + TextFormat.shortDebugString(response));
                }
            }
            catch (InvalidProtocolBufferException e) {
                Logger.error("Failed to parse response.", e);
            }
        });
    }

    RpcThread getThread() {
        return this.thread;
    }

    void send(RpcRequest request, RpcCallback<RpcResponse> callback) {
        Logger.debug("Writing RPC request... " + TextFormat.shortDebugString(request));
        this.requestMap.put(request.getId(), callback);
        this.memory.write(request.toByteArray());
    }

    Stream<RpcRequest> openStream(RpcRequest request, StreamObserver<RpcResponse> observer) {
        CommonThreadResponseConsumer<RpcResponse> consumer = new CommonThreadResponseConsumer<RpcResponse>();
        this.send(request, consumer);
        consumer.await();
        this.requestMap.put(request.getId(), observer);
        return new RpcStream();
    }

    @Override
    public void close() {
        this.memory.close();
        this.requestMap.forEach((rpcRequestId, observer) -> {
            try {
                observer.onError(new IllegalStateException("The connection has been closed."));
            }
            catch (Exception e) {
                Logger.error("The response observer has thrown an exception.", e);
            }
        });
        this.requestMap.clear();
    }

    @Override
    public boolean isClosed() {
        return this.memory.isClosed();
    }

    private class RpcStream
    implements Stream<RpcRequest> {
        private RpcStream() {
        }

        @Override
        public void write(RpcRequest request) {
            SharedMemoryChannel.this.memory.write(request.toByteArray());
        }
    }
}

