/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.transport;

import com.teamdev.jxbrowser.internal.rpc.transport.IpcLibrary;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemoryCallback;

public final class SharedMemory {
    private final long connectionId;
    private final IpcLibrary library;
    private final Callback connectionCallback;
    private ConnectionState connectionState;

    SharedMemory(String name, int size, IpcLibrary library) {
        this.library = library;
        this.connectionCallback = new Callback();
        this.connectionId = library.openConnection(name, size, this.connectionCallback, Thread.currentThread().getThreadGroup());
        if (this.connectionId == 0L) {
            throw new IllegalStateException("Failed to allocate shared memory.");
        }
        this.connectionState = ConnectionState.ALIVE;
    }

    void setCallback(SharedMemoryCallback callback) {
        this.connectionCallback.callback = callback;
    }

    void write(byte[] data) {
        if (this.isClosed()) {
            return;
        }
        this.library.sendData(this.connectionId, data);
    }

    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.library.closeConnection(this.connectionId);
        this.connectionState = ConnectionState.CLOSED;
    }

    public boolean isClosed() {
        return this.connectionState == ConnectionState.CLOSED;
    }

    public static final class Callback {
        private SharedMemoryCallback callback;

        public void onPacket(byte[] data) {
            if (this.callback != null) {
                this.callback.onDataReceived(data);
            }
        }
    }

    private static enum ConnectionState {
        ALIVE,
        CLOSED;

    }
}

