/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.transport;

import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.internal.rpc.RpcFunction;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallExecutor;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcThread;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemoryController;
import java.util.concurrent.atomic.AtomicReference;

public final class RpcThreadCallExecutor
implements RpcCallExecutor {
    private final Connection connection;

    public RpcThreadCallExecutor(Connection connection) {
        this.connection = connection;
    }

    @Override
    public <Request extends Message, Response extends Message> Response execute(Request request, RpcFunction<Request, Response> function) {
        Object key = new Object();
        RpcThread.TaskRunner taskRunner = this.connection.rpcThread().enterNestedLoop(key);
        SharedMemoryController controller = new SharedMemoryController();
        AtomicReference exceptionRef = new AtomicReference();
        AtomicReference responseRef = new AtomicReference();
        function.run(controller, request, response -> {
            if (controller.failed()) {
                exceptionRef.set(new IllegalStateException(controller.errorText()));
            } else {
                responseRef.set(response);
            }
            this.connection.rpcThread().exitNestedLoop(key);
        });
        taskRunner.processTasks();
        if (exceptionRef.get() != null) {
            throw new IllegalStateException("Failed to receive the response.", (Throwable)exceptionRef.get());
        }
        return (Response)((Message)responseRef.get());
    }
}

