/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.transport;

import com.teamdev.jxbrowser.VersionInfo;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Empty;
import com.teamdev.jxbrowser.deps.com.google.protobuf.TextFormat;
import com.teamdev.jxbrowser.event.Observable;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.event.internal.ObservableHelper;
import com.teamdev.jxbrowser.internal.BrowserThread;
import com.teamdev.jxbrowser.internal.licensing.License;
import com.teamdev.jxbrowser.internal.licensing.LicenseCheckRequest;
import com.teamdev.jxbrowser.internal.rpc.ConnectionCreated;
import com.teamdev.jxbrowser.internal.rpc.ConnectionData;
import com.teamdev.jxbrowser.internal.rpc.ConnectionId;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.rpc.event.ConnectionClosed;
import com.teamdev.jxbrowser.internal.rpc.event.ConnectionEvent;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.ConnectionChecker;
import com.teamdev.jxbrowser.internal.rpc.transport.ConnectionClosureException;
import com.teamdev.jxbrowser.internal.rpc.transport.ConnectionInitializationException;
import com.teamdev.jxbrowser.internal.rpc.transport.IpcLibrary;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcThread;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemory;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemoryChannel;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemoryConnection;
import com.teamdev.jxbrowser.internal.rpc.transport.StackTraceUtils;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.logging.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.ParametersAreNonnullByDefault;

public final class ConnectionServer
implements Observable<ConnectionEvent> {
    private static final int DEFAULT_AWAIT_CONNECTION_TIMEOUT_IN_SECONDS = 45;
    private final IpcLibrary library;
    private final RpcThread rpcThread;
    private final ServerSocket serverSocket;
    private final ObservableHelper<ConnectionEvent> observable;
    private final Map<ConnectionId, Connection> connectionMap;
    private final Lock lock;
    private final Condition connectionAdded;
    private State state;

    public ConnectionServer(IpcLibrary library, String licenseKey, List<StackTraceElement> stackTrace) {
        Preconditions.checkNotNull(library);
        Preconditions.checkNotNull(licenseKey);
        Preconditions.checkNotNull(stackTrace);
        this.library = library;
        this.lock = new ReentrantLock();
        this.connectionAdded = this.lock.newCondition();
        this.observable = new ObservableHelper();
        this.connectionMap = new HashMap<ConnectionId, Connection>();
        try {
            Logger.debug("Starting server...");
            this.serverSocket = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            Logger.debug("Starting server at port " + this.port() + "... [OK]");
        }
        catch (IOException e) {
            Logger.error("Failed to initialize connection manager", e);
            throw new ConnectionInitializationException(e);
        }
        this.state = State.RUNNING;
        this.rpcThread = new BrowserThread(String.valueOf(this.port()));
        Thread thread = new Thread(() -> {
            block2: {
                try {
                    this.acceptConnections(licenseKey, stackTrace);
                }
                catch (IOException e) {
                    if (this.state != State.RUNNING) break block2;
                    Logger.error("Failed to accept connection", e);
                }
            }
        });
        thread.setName("IPC Server Thread");
        thread.setDaemon(true);
        thread.start();
    }

    public int port() {
        return this.serverSocket.getLocalPort();
    }

    private boolean isClosed() {
        return this.serverSocket.isClosed();
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.state = State.CLOSING;
        this.rpcThread.close();
        Logger.debug("Stopping server...");
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            throw new ConnectionClosureException("Stopping server... [FAILED]", e);
        }
        Logger.debug("Stopping server... [OK]");
        this.state = State.CLOSED;
    }

    public Optional<Connection> awaitConnection(ConnectionId connectionId) {
        this.lock.lock();
        try {
            while (!this.connectionMap.containsKey(connectionId)) {
                Logger.debug("Awaiting connection with id: " + connectionId.getValue() + "...");
                if (!this.connectionAdded.await(45L, TimeUnit.SECONDS)) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("The current thread has been interrupted.", e);
        }
        finally {
            this.lock.unlock();
        }
        return Optional.ofNullable(this.connectionMap.get(connectionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptConnections(String licenseKey, List<StackTraceElement> stackTrace) throws IOException {
        Logger.debug("Accepting incoming connections...");
        while (!this.serverSocket.isClosed()) {
            Socket socket = this.serverSocket.accept();
            ConnectionCreated connectionCreatedRequest = ConnectionCreated.parseDelimitedFrom(socket.getInputStream());
            if (connectionCreatedRequest.getNeedsLicense()) {
                LicenseCheckRequest request = LicenseCheckRequest.newBuilder().setLicense(License.newBuilder().setText(licenseKey).build()).setProductName("JxBrowser").setProductVersion(VersionInfo.version()).setProjectContext(StackTraceUtils.packagesCallStack(stackTrace)).build();
                request.writeDelimitedTo(socket.getOutputStream());
            } else {
                ProtobufUtil.empty().writeDelimitedTo(socket.getOutputStream());
            }
            ConnectionData connectionData = connectionCreatedRequest.getConnectionData();
            Logger.debug("Accepting incoming connection " + TextFormat.shortDebugString(connectionData) + "...");
            Empty connectionEstablished = Empty.parseDelimitedFrom(socket.getInputStream());
            if (connectionEstablished == null) {
                Logger.debug("Accepting incoming connection " + TextFormat.shortDebugString(connectionData) + "... [FAIL]");
                return;
            }
            SharedMemory memory = new SharedMemory(connectionData.getMemoryName(), connectionData.getBufferSize(), this.library);
            ConnectionId connectionId = connectionCreatedRequest.getConnectionId();
            SharedMemoryConnection connection = new SharedMemoryConnection(connectionId, new SharedMemoryChannel(this.rpcThread, memory));
            connection.on(ConnectionClosed.class, event -> this.connectionMap.remove(connectionId));
            this.lock.lock();
            try {
                this.connectionMap.put(connectionId, connection);
                this.observable.notifyObservers(connectionCreatedRequest);
                this.connectionAdded.signal();
            }
            finally {
                this.lock.unlock();
            }
            Thread thread = new Thread((Runnable)new ConnectionChecker(socket, connection), "Socket Connection Checker: " + connectionId.getValue());
            thread.setDaemon(false);
            thread.start();
            Logger.debug("Accepting incoming connection " + TextFormat.shortDebugString(connectionData) + "... [OK]");
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    public <E extends ConnectionEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.observable.on(eventClass, observer);
    }

    private static enum State {
        RUNNING,
        CLOSING,
        CLOSED;

    }
}

