/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.stream;

import com.teamdev.jxbrowser.deps.com.google.protobuf.Descriptors;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.internal.EventHandler;
import com.teamdev.jxbrowser.internal.MessageProcessor;
import com.teamdev.jxbrowser.internal.rpc.NewService;
import com.teamdev.jxbrowser.internal.rpc.TextFormat;
import com.teamdev.jxbrowser.internal.rpc.stream.Stream;
import com.teamdev.jxbrowser.internal.rpc.stream.StreamObserver;
import com.teamdev.jxbrowser.internal.rpc.stream.StreamingFunction;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.logging.Logger;

public abstract class StreamCall<RequestT extends Message, ResponseT extends Message>
implements StreamObserver<ResponseT> {
    private final Message targetId;
    private final StreamingFunction<RequestT, ResponseT> streamProvider;
    private final NewService service;
    private final Descriptors.MethodDescriptor descriptor;
    private boolean subscribed;
    private Stream<RequestT> stream;
    private MessageProcessor<ResponseT> processor;
    private EventHandler<ResponseT> eventHandler;

    StreamCall(NewService service, Descriptors.MethodDescriptor descriptor, StreamingFunction<RequestT, ResponseT> streamProvider, Message targetId) {
        Preconditions.checkArgument(descriptor.toProto().getClientStreaming());
        Preconditions.checkArgument(descriptor.toProto().getServerStreaming());
        this.service = service;
        this.descriptor = descriptor;
        this.targetId = targetId;
        this.streamProvider = streamProvider;
    }

    Message targetId() {
        return this.targetId;
    }

    NewService service() {
        return this.service;
    }

    Descriptors.MethodDescriptor descriptor() {
        return this.descriptor;
    }

    public void subscribe() {
        if (!this.isSubscribed()) {
            Logger.debug("Subscribe " + this.descriptor.getFullName() + ", " + TextFormat.shortDebugString(this.targetId));
            this.stream = this.streamProvider.invoke(this);
            this.stream.write(this.createSubscriptionRequest(Subscription.SUBSCRIBE));
        }
        this.subscribed = true;
    }

    public void unsubscribe() {
        if (this.isSubscribed()) {
            Logger.debug("Unsubscribe " + this.descriptor.getFullName() + ", " + TextFormat.shortDebugString(this.targetId));
            this.stream.write(this.createSubscriptionRequest(Subscription.UNSUBSCRIBE));
        }
        this.subscribed = false;
    }

    protected abstract Message createSubscriptionRequest(Subscription var1);

    public Stream<RequestT> stream() {
        return this.stream;
    }

    boolean isSubscribed() {
        return this.subscribed;
    }

    public void setPreProcessor(MessageProcessor<ResponseT> processor) {
        this.processor = processor;
        if (!this.isSubscribed()) {
            this.subscribe();
        }
    }

    public void resetPreProcessor() {
        this.processor = null;
    }

    public void setEventHandler(EventHandler<ResponseT> eventHandler) {
        this.eventHandler = eventHandler;
        if (!this.isSubscribed()) {
            this.subscribe();
        }
    }

    public void resetEventHandler() {
        this.eventHandler = null;
    }

    void preProcess(ResponseT message) {
        if (this.processor != null) {
            this.processor.process(message);
        }
    }

    boolean handleEvent(ResponseT message) {
        if (this.eventHandler != null) {
            return this.eventHandler.handle(message);
        }
        return false;
    }

    static enum Subscription {
        SUBSCRIBE,
        UNSUBSCRIBE;

    }
}

