/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.stream;

import com.teamdev.jxbrowser.deps.com.google.protobuf.Any;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Descriptors;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.event.Event;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.internal.NewObservableHelper;
import com.teamdev.jxbrowser.event.internal.SubscriptionImpl;
import com.teamdev.jxbrowser.internal.rpc.NewService;
import com.teamdev.jxbrowser.internal.rpc.stream.StreamCall;
import com.teamdev.jxbrowser.internal.rpc.stream.StreamingFunction;

public class EventStreamCall<RequestT extends Message, ResponseT extends Message & Event>
extends StreamCall<RequestT, ResponseT> {
    private final NewObservableHelper observable = new NewObservableHelper();

    public EventStreamCall(NewService service, Descriptors.MethodDescriptor descriptor, StreamingFunction<RequestT, ResponseT> streamProvider, Message targetId) {
        super(service, descriptor, streamProvider, targetId);
    }

    public <T extends Event> SubscriptionImpl subscribe(Observer<T> observer) {
        SubscriptionImpl subscription = this.observable.addObserver(observer);
        if (!this.isSubscribed()) {
            this.subscribe();
        }
        subscription.onUnsubscribe(() -> {
            if (!this.observable.hasSubscribers()) {
                this.unsubscribe();
            }
        });
        return subscription;
    }

    public <T extends Event> void notify(T event) {
        this.observable.notifyObservers(event);
    }

    @Override
    protected Message createSubscriptionRequest(StreamCall.Subscription subscription) {
        Message requestPrototype = this.service().getRequestPrototype(this.descriptor());
        Descriptors.Descriptor requestDescriptor = requestPrototype.getDescriptorForType();
        String name = subscription == StreamCall.Subscription.SUBSCRIBE ? "subscribe" : "unsubscribe";
        Descriptors.FieldDescriptor subscribeField = requestDescriptor.findFieldByName(name);
        return requestPrototype.toBuilder().setField(subscribeField, Any.pack(this.targetId())).build();
    }

    @Override
    public void onNext(ResponseT message) {
        this.preProcess(message);
        if (!this.handleEvent(message)) {
            this.notify((Event)message);
        }
    }

    @Override
    public void onError(Throwable t) {
    }

    @Override
    public void onCompleted() {
    }
}

