/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.stream;

import com.teamdev.jxbrowser.callback.AsyncCallback;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.callback.SyncCallback;
import com.teamdev.jxbrowser.callback.internal.CallbackUtil;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Descriptors;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.internal.rpc.NewService;
import com.teamdev.jxbrowser.internal.rpc.stream.StreamCall;
import com.teamdev.jxbrowser.internal.rpc.stream.StreamingFunction;
import com.teamdev.jxbrowser.internal.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.util.function.Consumer;

public class CallbackStreamCall<RequestT extends Message, ResponseT extends Message>
extends StreamCall<RequestT, ResponseT> {
    private Callback callback;
    private Class callbackClass;

    public CallbackStreamCall(NewService service, Descriptors.MethodDescriptor descriptor, StreamingFunction<RequestT, ResponseT> streamProvider, Message targetId) {
        super(service, descriptor, streamProvider, targetId);
    }

    @Override
    protected Message createSubscriptionRequest(StreamCall.Subscription subscription) {
        Message requestPrototype = this.service().getRequestPrototype(this.descriptor());
        Descriptors.Descriptor requestDescriptor = requestPrototype.getDescriptorForType();
        Descriptors.FieldDescriptor subscribeField = requestDescriptor.findFieldByName("subscribe");
        Descriptors.FieldDescriptor targetField = requestDescriptor.findFieldByName("target");
        return requestPrototype.toBuilder().setField(subscribeField, subscription == StreamCall.Subscription.SUBSCRIBE).setField(targetField, this.targetId()).build();
    }

    public <C extends Callback> Callback set(Class<C> callbackClass, C callback) {
        if (!this.isSubscribed()) {
            this.subscribe();
        }
        this.callbackClass = callbackClass;
        this.callback = callback;
        return callback;
    }

    public Callback get() {
        return this.callback;
    }

    public Callback remove() {
        if (this.isSubscribed()) {
            this.unsubscribe();
        }
        Callback result = this.callback;
        this.callback = null;
        return result;
    }

    @Override
    public void onNext(ResponseT message) {
        this.preProcess(message);
        if (this.callback == null) {
            return;
        }
        if (!this.callbackClass.isAssignableFrom(this.callback.getClass())) {
            return;
        }
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        Descriptors.FieldDescriptor paramsField = descriptor.findFieldByName("request");
        Descriptors.FieldDescriptor responseField = descriptor.findFieldByName("response");
        Object params = message.getField(paramsField);
        Consumer<Message> done = response -> this.stream().write(message.newBuilderForType().setField(responseField, response).build());
        if (AsyncCallback.class.isAssignableFrom(this.callbackClass)) {
            AsyncCallback asyncCallback = (AsyncCallback)this.callback;
            Class actionClass = CallbackUtil.determineActionClass(this.callbackClass);
            Constructor<?> constructor = ReflectionUtil.getConstructor(actionClass, Consumer.class);
            AsyncCallbackAction responder = (AsyncCallbackAction)ReflectionUtil.newInstance(constructor, done);
            asyncCallback.on(params, responder);
        } else {
            SyncCallback syncCallback = (SyncCallback)this.callback;
            done.accept((Message)syncCallback.on(params));
        }
    }

    @Override
    public void onError(Throwable t) {
    }

    @Override
    public void onCompleted() {
    }
}

