/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc;

import com.teamdev.jxbrowser.deps.com.google.protobuf.Descriptors;
import com.teamdev.jxbrowser.deps.com.google.protobuf.InvalidProtocolBufferException;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.deps.com.google.protobuf.RpcCallback;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Service;
import com.teamdev.jxbrowser.internal.rpc.ResponseData;
import com.teamdev.jxbrowser.internal.rpc.RpcHandler;
import com.teamdev.jxbrowser.internal.rpc.RpcLogging;
import com.teamdev.jxbrowser.internal.rpc.RpcRequest;
import com.teamdev.jxbrowser.internal.rpc.RpcResponse;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemoryController;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;

public final class ServiceRpcHandler
implements RpcHandler {
    private final List<Service> services = new CopyOnWriteArrayList<Service>();
    private final ExecutorService taskRunner;

    ServiceRpcHandler(ExecutorService taskRunner) {
        this.taskRunner = taskRunner;
    }

    void addCallbackService(Service service) {
        this.services.add(service);
    }

    void removeCallbackService(Service service) {
        this.services.remove(service);
    }

    @Override
    public void onRequest(RpcRequest rpcRequest, RpcCallback<RpcResponse> callback) {
        for (Service service : this.services) {
            Descriptors.MethodDescriptor method = service.getDescriptorForType().findMethodByName(rpcRequest.getMethodName());
            if (method == null) continue;
            try {
                Message requestPrototype = service.getRequestPrototype(method);
                Message request = requestPrototype.newBuilderForType().mergeFrom(rpcRequest.getRequestData().getSerializedMessage()).build();
                RpcLogging.logServerRequest(rpcRequest, request);
                SharedMemoryController controller = new SharedMemoryController();
                this.taskRunner.submit(() -> {
                    try {
                        service.callMethod(method, controller, request, parameter -> {
                            RpcResponse response = RpcResponse.newBuilder().setRequestId(rpcRequest.getId()).setResponseData(ResponseData.newBuilder().setSerializedMessage(parameter.toByteString()).build()).build();
                            RpcLogging.logServerResponse(response, rpcRequest, parameter);
                            callback.run(response);
                        });
                    }
                    catch (Exception e) {
                        Logger.error("Failed to call method.", e);
                    }
                });
            }
            catch (InvalidProtocolBufferException e) {
                Logger.error("Failed to parse request.", e);
            }
        }
    }
}

