/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc;

import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.internal.rpc.RpcRequest;
import com.teamdev.jxbrowser.internal.rpc.RpcRequestId;
import com.teamdev.jxbrowser.internal.rpc.RpcResponse;
import com.teamdev.jxbrowser.internal.rpc.TextFormat;
import com.teamdev.jxbrowser.logging.Logger;

final class RpcLogging {
    RpcLogging() {
    }

    static void logClientRequest(RpcRequest rpcRequest, Message request) {
        if (Logger.isDebugEnabled()) {
            RpcLogging.logRpcMessage(">", rpcRequest.getId(), rpcRequest.getServiceName(), rpcRequest.getMethodName(), request);
        }
    }

    static void logClientResponse(RpcResponse rpcResponse, RpcRequest rpcRequest, Message response) {
        if (Logger.isDebugEnabled()) {
            RpcLogging.logRpcMessage("<", rpcResponse.getRequestId(), rpcRequest.getServiceName(), rpcRequest.getMethodName(), response);
        }
    }

    static void logServerRequest(RpcRequest rpcRequest, Message request) {
        if (Logger.isDebugEnabled()) {
            RpcLogging.logRpcMessage("<", rpcRequest.getId(), rpcRequest.getServiceName(), rpcRequest.getMethodName(), request);
        }
    }

    static void logServerResponse(RpcResponse rpcResponse, RpcRequest rpcRequest, Message response) {
        if (Logger.isDebugEnabled()) {
            RpcLogging.logRpcMessage("<", rpcResponse.getRequestId(), rpcRequest.getServiceName(), rpcRequest.getMethodName(), response);
        }
    }

    private static void logRpcMessage(String prefix, RpcRequestId requestId, String serviceName, String methodName, Message message) {
        if (Logger.isDebugEnabled()) {
            String messageString = TextFormat.shortDebugString(message);
            Logger.debug("{0} {1}: {2}.{3} [{4}]", prefix, requestId.getValue(), serviceName, methodName, messageString);
        }
    }
}

