/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc;

import com.teamdev.jxbrowser.Closeable;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.callback.internal.CallbackUtil;
import com.teamdev.jxbrowser.callback.internal.Invoker;
import com.teamdev.jxbrowser.deps.com.google.protobuf.DescriptorProtos;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Descriptors;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.event.Event;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.internal.EventSource;
import com.teamdev.jxbrowser.event.internal.SubscriptionImpl;
import com.teamdev.jxbrowser.event.internal.rpc.EventSubscription;
import com.teamdev.jxbrowser.internal.EventHandler;
import com.teamdev.jxbrowser.internal.MessageProcessor;
import com.teamdev.jxbrowser.internal.rpc.Channel;
import com.teamdev.jxbrowser.internal.rpc.NewService;
import com.teamdev.jxbrowser.internal.rpc.NewServiceChannel;
import com.teamdev.jxbrowser.internal.rpc.RpcFunction;
import com.teamdev.jxbrowser.internal.rpc.stream.CallbackStreamCall;
import com.teamdev.jxbrowser.internal.rpc.stream.EventStreamCall;
import com.teamdev.jxbrowser.internal.rpc.stream.Stream;
import com.teamdev.jxbrowser.internal.rpc.stream.StreamObserver;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallExecutor;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.internal.rpc.transport.SharedMemoryController;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.internal.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class NewServiceConnection<StubT extends NewService>
implements EventSource<Event>,
Invoker,
Closeable {
    private final Message targetId;
    private final StubT stub;
    private final NewServiceChannel serviceChannel;
    private final Map<Class, EventStreamCall> events;
    private final Map<CallbackInfo, CallbackStreamCall> callbacks;

    public NewServiceConnection(Message targetId, Connection connection, StubFactory<StubT> stubFactoryMethod) {
        this.serviceChannel = new NewServiceChannel(connection);
        this.stub = (NewService)stubFactoryMethod.newStub(this.serviceChannel);
        this.targetId = targetId;
        this.events = new HashMap<Class, EventStreamCall>();
        this.callbacks = new HashMap<CallbackInfo, CallbackStreamCall>();
        this.resolveStreamingMethods();
    }

    private static String toJavaMethodName(String name) {
        char[] arr = name.toCharArray();
        arr[0] = Character.toLowerCase(arr[0]);
        return new String(arr);
    }

    private void resolveStreamingMethods() {
        List<Descriptors.MethodDescriptor> methods = this.stub.getDescriptorForType().getMethods();
        for (Descriptors.MethodDescriptor method : methods) {
            if (!NewServiceConnection.isEvent(method) && !NewServiceConnection.isCallback(method)) continue;
            try {
                Message responsePrototype = this.stub.getResponsePrototype(method);
                Class<?> responseClass = responsePrototype.getClass();
                Method rpcMethod = ReflectionUtil.getMethod(this.stub.getClass(), NewServiceConnection.toJavaMethodName(method.getName()), StreamObserver.class);
                if (NewServiceConnection.isEvent(method)) {
                    this.events.put(responseClass, new EventStreamCall((NewService)this.stub, method, observer -> (Stream)ReflectionUtil.invoke(this.stub, rpcMethod, observer), this.targetId));
                }
                if (!NewServiceConnection.isCallback(method)) continue;
                Descriptors.Descriptor responseDescriptor = responsePrototype.getDescriptorForType();
                Descriptors.FieldDescriptor paramsField = responseDescriptor.findFieldByName("request");
                Object paramsPrototype = responsePrototype.getField(paramsField);
                this.callbacks.put(new CallbackInfo(responseClass, paramsPrototype.getClass()), new CallbackStreamCall((NewService)this.stub, method, observer -> (Stream)ReflectionUtil.invoke(this.stub, rpcMethod, observer), this.targetId));
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to resolve service methods.", e);
            }
        }
    }

    private <T> Optional<EventStreamCall> findEventStreamCall(Class<T> cls) {
        for (Map.Entry<Class, EventStreamCall> entry : this.events.entrySet()) {
            if (!cls.isAssignableFrom(entry.getKey())) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    private <T> Optional<CallbackStreamCall> findCallbackStreamCall(Class<T> cls) {
        for (Map.Entry<CallbackInfo, CallbackStreamCall> entry : this.callbacks.entrySet()) {
            CallbackInfo info = entry.getKey();
            if (!cls.isAssignableFrom(info.messageType()) && !cls.isAssignableFrom(info.requestType())) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public <T> void setPreProcessor(Class<T> cls, MessageProcessor<T> processor) {
        Optional<EventStreamCall> eventStreamCall = this.findEventStreamCall(cls);
        Optional<CallbackStreamCall> callbackStreamCall = this.findCallbackStreamCall(cls);
        eventStreamCall.ifPresent(streamCall -> streamCall.setPreProcessor(processor));
        callbackStreamCall.ifPresent(streamCall -> streamCall.setPreProcessor(processor));
        if (!eventStreamCall.isPresent() && !callbackStreamCall.isPresent()) {
            throw new IllegalArgumentException("Failed to match the class " + cls + " to the existing service methods.");
        }
    }

    public <T extends Message> void setEventHandler(Class<T> cls, EventHandler<T> eventHandler) {
        Optional<EventStreamCall> eventStreamCall = this.findEventStreamCall(cls);
        eventStreamCall.ifPresent(streamCall -> streamCall.setEventHandler(eventHandler));
        if (!eventStreamCall.isPresent()) {
            throw new IllegalArgumentException("Failed to match the class " + cls + " to the existing service methods.");
        }
    }

    public <T extends Event> void subscribe(Class<T> eventClass) {
        EventStreamCall streamCall = this.findEventStreamCall(eventClass).orElseThrow(IllegalArgumentException::new);
        streamCall.subscribe();
    }

    public <T extends Event> void unsubscribe(Class<T> eventClass) {
        EventStreamCall streamCall = this.findEventStreamCall(eventClass).orElseThrow(IllegalArgumentException::new);
        streamCall.unsubscribe();
    }

    @Override
    public Set<Class<? extends Event>> eventTypes() {
        HashSet<Class<? extends Event>> eventTypes = new HashSet<Class<? extends Event>>();
        for (Class eventClass : this.events.keySet()) {
            eventTypes.add(eventClass);
        }
        return eventTypes;
    }

    @Override
    public <T extends Event> SubscriptionImpl on(Class<T> eventClass, Observer<T> observer) {
        EventStreamCall eventStreamCall = this.findEventStreamCall(eventClass).orElseThrow(IllegalArgumentException::new);
        return eventStreamCall.subscribe(observer);
    }

    @Override
    public <T extends Event> void dispatch(T event) {
        EventStreamCall eventStreamCall = this.findEventStreamCall(event.getClass()).orElseThrow(IllegalArgumentException::new);
        eventStreamCall.notify(event);
    }

    @Override
    public <T extends Callback> boolean invokes(Class<T> callbackClass) {
        return this.findCallbackStreamCall(CallbackUtil.determineRequestClass(callbackClass)).isPresent();
    }

    @Override
    public <C extends Callback> C set(Class<C> callbackClass, C callback) {
        Preconditions.checkNotNull(callbackClass);
        Preconditions.checkNotNull(callback);
        CallbackStreamCall streamCall = this.findCallbackStreamCall(CallbackUtil.determineRequestClass(callbackClass)).orElseThrow(IllegalArgumentException::new);
        return (C)streamCall.set(callbackClass, callback);
    }

    @Override
    public <C extends Callback> Optional<C> get(Class<C> callbackClass) {
        Preconditions.checkNotNull(callbackClass);
        CallbackStreamCall streamCall = this.findCallbackStreamCall(CallbackUtil.determineRequestClass(callbackClass)).orElseThrow(() -> new IllegalArgumentException(callbackClass.toString()));
        return Optional.ofNullable(streamCall.get());
    }

    @Override
    public <C extends Callback> C remove(Class<C> callbackClass) {
        Preconditions.checkNotNull(callbackClass);
        CallbackStreamCall streamCall = this.findCallbackStreamCall(CallbackUtil.determineRequestClass(callbackClass)).orElseThrow(() -> new IllegalArgumentException(callbackClass.toString()));
        return (C)streamCall.remove();
    }

    private static boolean isEvent(Descriptors.MethodDescriptor descriptor) {
        DescriptorProtos.MethodDescriptorProto methodProto = descriptor.toProto();
        if (methodProto.getServerStreaming() && methodProto.getClientStreaming()) {
            return descriptor.getInputType().getName().equalsIgnoreCase(EventSubscription.class.getSimpleName());
        }
        return false;
    }

    private static boolean isCallback(Descriptors.MethodDescriptor descriptor) {
        DescriptorProtos.MethodDescriptorProto methodProto = descriptor.toProto();
        if (methodProto.getServerStreaming() && methodProto.getClientStreaming()) {
            return !NewServiceConnection.isEvent(descriptor);
        }
        return false;
    }

    public StubT stub() {
        return this.stub;
    }

    @Override
    public void close() {
        this.events.values().forEach(eventStreamCall -> {
            eventStreamCall.resetPreProcessor();
            eventStreamCall.resetEventHandler();
            eventStreamCall.unsubscribe();
        });
        this.events.clear();
        this.callbacks.values().forEach(callbackStreamCall -> {
            callbackStreamCall.resetPreProcessor();
            callbackStreamCall.resetEventHandler();
            callbackStreamCall.remove();
        });
        this.callbacks.clear();
    }

    @Override
    public boolean isClosed() {
        return this.connection().isClosed();
    }

    public Connection connection() {
        return this.serviceChannel.connection();
    }

    public <Request extends Message, Response extends Message> Response invoke(RpcFunction<Request, Response> function, Request request) {
        Preconditions.checkState(!this.isClosed());
        RpcCallExecutor callExecutor = RpcCallExecutor.newInstance(this.connection());
        return callExecutor.execute(request, function);
    }

    public <Request extends Message, Response extends Message> void invokeAsync(RpcFunction<Request, Response> function, Request request, RpcCallback<Response> done) {
        Preconditions.checkState(!this.isClosed());
        SharedMemoryController controller = new SharedMemoryController();
        function.run(controller, request, response -> this.connection().rpcThread().submit(() -> {
            if (controller.failed()) {
                done.onError(new IllegalStateException(controller.errorText()));
            } else {
                done.onNext((Object)response);
            }
        }));
    }

    public <Request extends Message, Response extends Message> void invokeAsync(RpcFunction<Request, Response> function, Request request) {
        Preconditions.checkState(!this.isClosed());
        this.invokeAsync(function, request, new RpcCallback<Response>(){});
    }

    private static class CallbackInfo {
        private final Class messageType;
        private final Class requestType;

        CallbackInfo(Class messageType, Class requestType) {
            this.messageType = messageType;
            this.requestType = requestType;
        }

        Class messageType() {
            return this.messageType;
        }

        Class requestType() {
            return this.requestType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CallbackInfo that = (CallbackInfo)o;
            return Objects.equals(this.messageType, that.messageType) && Objects.equals(this.requestType, that.requestType);
        }

        public int hashCode() {
            return Objects.hash(this.messageType, this.requestType);
        }
    }

    @FunctionalInterface
    public static interface StubFactory<CommandsT> {
        public CommandsT newStub(Channel var1);
    }
}

