/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc;

import com.teamdev.jxbrowser.deps.com.google.protobuf.Descriptors;
import com.teamdev.jxbrowser.deps.com.google.protobuf.InvalidProtocolBufferException;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.deps.com.google.protobuf.RpcController;
import com.teamdev.jxbrowser.internal.rpc.Channel;
import com.teamdev.jxbrowser.internal.rpc.Id;
import com.teamdev.jxbrowser.internal.rpc.RequestData;
import com.teamdev.jxbrowser.internal.rpc.RpcLogging;
import com.teamdev.jxbrowser.internal.rpc.RpcRequest;
import com.teamdev.jxbrowser.internal.rpc.RpcRequestId;
import com.teamdev.jxbrowser.internal.rpc.RpcResponse;
import com.teamdev.jxbrowser.internal.rpc.Status;
import com.teamdev.jxbrowser.internal.rpc.StreamData;
import com.teamdev.jxbrowser.internal.rpc.stream.Stream;
import com.teamdev.jxbrowser.internal.rpc.stream.StreamObserver;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.logging.Logger;

public final class NewServiceChannel
implements Channel {
    private final Connection connection;

    NewServiceChannel(Connection connection) {
        this.connection = connection;
    }

    public Connection connection() {
        return this.connection;
    }

    @Override
    public void callMethod(Descriptors.MethodDescriptor method, final RpcController controller, Message request, final Message responsePrototype, final com.teamdev.jxbrowser.deps.com.google.protobuf.RpcCallback<Message> done) {
        final RpcRequest rpcRequest = RpcRequest.newBuilder().setId(RpcRequestId.newBuilder().setValue(Id.generate()).build()).setServiceName(method.getService().getFullName()).setMethodName(method.getName()).setRequestData(RequestData.newBuilder().setSerializedMessage(request.toByteString()).build()).build();
        RpcLogging.logClientRequest(rpcRequest, request);
        this.connection.send(rpcRequest, new RpcCallback<RpcResponse>(){

            @Override
            public void onNext(RpcResponse rpcResponse) {
                try {
                    Message.Builder builder = responsePrototype.newBuilderForType().mergeFrom(rpcResponse.getResponseData().getSerializedMessage());
                    if (builder.isInitialized()) {
                        Message response = builder.build();
                        RpcLogging.logClientResponse(rpcResponse, rpcRequest, response);
                        done.run(response);
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    controller.setFailed("Failed to parse response." + e.getMessage());
                    done.run(null);
                }
            }

            @Override
            public void onError(Throwable t) {
                controller.setFailed(t.getMessage());
                done.run(null);
            }
        });
    }

    @Override
    public <RequestT extends Message, ResponseT extends Message> Stream<RequestT> callMethod(Descriptors.MethodDescriptor method, ResponseT responsePrototype, StreamObserver<ResponseT> observer) {
        return new StreamImpl(this, method, responsePrototype, observer);
    }

    private static class StreamImpl<RequestT extends Message, ResponseT extends Message>
    implements Stream<RequestT>,
    StreamObserver<RpcResponse> {
        private final ResponseT prototype;
        private final StreamObserver<ResponseT> observer;
        private final RpcRequest requestStub;
        private final Stream<RpcRequest> stream;
        final /* synthetic */ NewServiceChannel this$0;

        private StreamImpl(Descriptors.MethodDescriptor method, ResponseT prototype, StreamObserver<ResponseT> observer) {
            this.this$0 = var1_1;
            this.prototype = prototype;
            this.observer = observer;
            this.requestStub = this.createOpenStreamRequest(method);
            this.stream = ((NewServiceChannel)var1_1).connection.openStream(this.requestStub, this);
        }

        private RpcRequest createOpenStreamRequest(Descriptors.MethodDescriptor method) {
            return RpcRequest.newBuilder().setId(RpcRequestId.newBuilder().setValue(Id.generate()).build()).setServiceName(method.getService().getFullName()).setMethodName(method.getName()).setStreamData(StreamData.newBuilder().build()).build();
        }

        @Override
        public void write(RequestT value) {
            RpcRequest rpcRequest = this.requestStub.toBuilder().setStreamData(StreamData.newBuilder().setSerializedMessage(value.toByteString()).build()).build();
            RpcLogging.logClientRequest(rpcRequest, value);
            this.stream.write(rpcRequest);
        }

        @Override
        public void onNext(RpcResponse rpcResponse) {
            Logger.debug("Submitting RPC response to queue...");
            this.this$0.connection.rpcThread().submit(() -> {
                StreamData streamData = rpcResponse.getStreamData();
                if (streamData.getStatus() == Status.FAILED) {
                    this.observer.onError(new RuntimeException());
                    return;
                }
                if (streamData.getStageCase() == StreamData.StageCase.SERIALIZED_MESSAGE) {
                    try {
                        Message.Builder builder = this.prototype.toBuilder().mergeFrom(streamData.getSerializedMessage());
                        if (builder.isInitialized()) {
                            Message response = builder.build();
                            RpcLogging.logServerResponse(rpcResponse, this.requestStub, response);
                            this.observer.onNext(response);
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        Logger.error("Failed to deserialize proto message.", e);
                        this.observer.onError(e);
                    }
                }
                if (streamData.getStageCase() == StreamData.StageCase.STREAM_CLOSED) {
                    this.observer.onCompleted();
                }
            });
        }

        @Override
        public void onError(Throwable t) {
        }

        @Override
        public void onCompleted() {
        }
    }
}

