/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.platform;

import com.teamdev.jxbrowser.internal.ChromiumFiles;
import com.teamdev.jxbrowser.internal.DirectoryStreamException;
import com.teamdev.jxbrowser.internal.ExecutablePathResolver;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ExecutablePathResolverWin
implements ExecutablePathResolver {
    private final Path chromiumDir;
    private final ChromiumFiles chromiumFiles;

    public ExecutablePathResolverWin(Path chromiumDir, @Nullable ChromiumFiles chromiumFiles) {
        this.chromiumDir = chromiumDir;
        this.chromiumFiles = chromiumFiles;
    }

    @Override
    public Optional<Path> resolve() {
        if (this.chromiumFiles != null) {
            Path path2 = this.chromiumDir.resolve(this.chromiumFiles.executableFile().name());
            if (Files.exists(path2, new LinkOption[0])) {
                return Optional.of(path2);
            }
            return Optional.empty();
        }
        Path executable32 = this.chromiumDir.resolve("browsercore32.exe");
        Path executable64 = this.chromiumDir.resolve("browsercore64.exe");
        try {
            return Files.walk(this.chromiumDir, new FileVisitOption[0]).filter(path -> path.equals(executable32) || path.equals(executable64)).max(Comparator.comparing(o -> o.getFileName().toString()));
        }
        catch (IOException e) {
            throw new DirectoryStreamException(this.chromiumDir, (Throwable)e);
        }
    }
}

