/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.JniLibrary;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.internal.util.StringUtil;
import com.teamdev.jxbrowser.logging.Logger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;

public final class ToolkitLibrary
extends JniLibrary {
    private static final Map<String, ToolkitLibrary> libraryPathToToolkitLibraryMap = new HashMap<String, ToolkitLibrary>();

    public static ToolkitLibrary getInstance(Path dir) {
        Preconditions.checkNotNull(dir);
        String absolutePath = dir.toAbsolutePath().toString();
        if (!libraryPathToToolkitLibraryMap.containsKey(absolutePath)) {
            libraryPathToToolkitLibraryMap.put(absolutePath, new ToolkitLibrary(absolutePath));
        }
        return libraryPathToToolkitLibraryMap.get(absolutePath);
    }

    private ToolkitLibrary(String dir) {
        super("browsercore_toolkit", dir);
    }

    public native long getCurrentProcessId();

    public native void updatePixels(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int[] var13);

    public native void updatePixels(String var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int[] var10);

    public boolean isDirectoryInUse(Path dataDir) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(dataDir.toFile().getAbsolutePath().getBytes(StandardCharsets.UTF_8));
            byte[] digestBytes = digest.digest();
            String digestStr = StringUtil.printHexBinary(digestBytes);
            return this.isDirectoryInUse(digestStr);
        }
        catch (Exception ex) {
            Logger.warn("Failed to compute hash for the data directory path.", ex);
            return false;
        }
    }

    private native boolean isDirectoryInUse(String var1);

    public native int getProcessDpiAwareness();

    public native double getScaleFactorForDisplay(String var1);

    public native String getPrimaryDisplayId();

    public native String getDisplayIdForWindow(long var1);

    public native String getDisplayIdForWindowAndScale(long var1, double var3);

    public native void focusHWND(long var1);

    public native long createNsView(int var1, int var2, int var3, int var4);

    public native void deleteNsView(long var1);

    public native void showNsView(long var1, long var3);

    public native void hideNsView(long var1);

    public native void setNsViewBounds(long var1, int var3, int var4, int var5, int var6);

    public native void setNsViewSurface(long var1, String var3);

    public native void createMachService(String var1);

    public native void deleteMachService(String var1);

    public native byte[] serializeUrlForPasteboard(String var1);

    public native String readUrlFromPasteboard();
}

