/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.os.Environment;
import java.nio.file.Paths;
import java.security.AccessController;

public class JniLibrary {
    protected JniLibrary(String name, String dir) {
        AccessController.doPrivileged(() -> {
            System.load(Paths.get(dir, JniLibrary.toPlatformName(name)).toFile().getAbsolutePath());
            return null;
        });
    }

    private static String toPlatformName(String libraryName) {
        if (Environment.isWindows()) {
            if (Environment.is32Bit()) {
                return libraryName + "32.dll";
            }
            return libraryName + "64.dll";
        }
        if (Environment.isMac()) {
            return "lib" + libraryName + ".dylib";
        }
        if (Environment.isLinux()) {
            return "lib" + libraryName + ".so";
        }
        throw new IllegalStateException("Unsupported operating system.");
    }
}

