/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.DirectoryCreationException;
import com.teamdev.jxbrowser.logging.Logger;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;

public final class FileUtil {
    public static void createDirs(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new DirectoryCreationException(path, (Throwable)e);
            }
        }
    }

    public static void deleteDir(Path path) {
        File dir = path.toFile();
        if (!dir.isDirectory()) {
            if (!dir.delete()) {
                dir.deleteOnExit();
            }
        } else {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    FileUtil.deleteDir(file.toPath());
                }
            }
            FileUtil.deleteFile(dir.toPath());
        }
    }

    public static void deleteFile(Path path) {
        File file = path.toFile();
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public static Path createTempDir(String prefix) {
        try {
            File dir = File.createTempFile(prefix, UUID.randomUUID().toString());
            if (!dir.delete()) {
                throw new IllegalStateException("Failed to delete temp file: " + dir.getAbsolutePath());
            }
            if (!dir.mkdir()) {
                throw new IllegalStateException("Failed to create temp dir: " + dir.getAbsolutePath());
            }
            return dir.toPath();
        }
        catch (IOException e) {
            throw new DirectoryCreationException("Failed to create temporary directory.", (Throwable)e);
        }
    }

    public static byte[] readFile(Path path) {
        File file = path.toFile();
        byte[] data = null;
        try {
            DataInputStream stream = new DataInputStream(new FileInputStream(file));
            data = new byte[stream.available()];
            stream.readFully(data);
        }
        catch (IOException e) {
            Logger.error("Failed to read the file: " + file.getAbsolutePath(), e);
        }
        return data;
    }

    public static void restorePermissionsForFile(Path path) throws IOException {
        File file = path.toFile();
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.canExecute() && !file.setExecutable(true, false)) {
            throw new IOException("Failed to update permissions for file: " + file.getAbsolutePath());
        }
    }

    private FileUtil() {
    }

    public static File findByTemplate(String dir, String fileNameTemplate) {
        File[] files;
        File directory = new File(dir);
        if (directory.isDirectory() && (files = directory.listFiles((dir1, name) -> name.startsWith(fileNameTemplate))) != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    static void validateDirectory(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("The " + dir.getAbsolutePath() + " directory does not exist and cannot be created.");
        }
        if (!dir.isDirectory()) {
            throw new IOException("The " + dir.getAbsolutePath() + " path does not refer to a directory.");
        }
        if (!FileUtil.canWriteToDirectory(dir.getAbsolutePath())) {
            throw new IOException("There is no write permission to the " + dir.getAbsolutePath() + " directory.");
        }
    }

    private static boolean canWriteToDirectory(String dirPath) {
        long time = System.currentTimeMillis();
        String tempFile = dirPath + File.separator + "jxbrowser-test-file-" + time;
        File file = new File(tempFile);
        try {
            new FileOutputStream(file, true).close();
            file.delete();
        }
        catch (IOException ignored) {
            return false;
        }
        return true;
    }
}

