/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.Closeable;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class CloseableImpl<T extends CloseableImpl>
implements Closeable {
    private final AtomicBoolean closed = new AtomicBoolean();
    private Consumer<T> onClosedConsumer;

    protected static void closeIfNecessary(Lazy<? extends Closeable> target) {
        Preconditions.checkNotNull(target);
        target.maybeGet().ifPresent(Closeable::close);
    }

    public void onClosed(Consumer<T> consumer) {
        Preconditions.checkNotNull(consumer);
        this.onClosedConsumer = consumer;
    }

    protected final void checkNotClosed() {
        Preconditions.checkState(!this.isClosed());
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.closed.set(true);
            if (this.onClosedConsumer != null) {
                this.onClosedConsumer.accept(this);
            }
        }
    }

    @Override
    public final boolean isClosed() {
        return this.closed.get();
    }
}

