/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.ChromiumFiles;
import com.teamdev.jxbrowser.internal.ChromiumVerifier;
import com.teamdev.jxbrowser.internal.platform.ChromiumVerifierLinux;
import com.teamdev.jxbrowser.internal.platform.ChromiumVerifierMac;
import com.teamdev.jxbrowser.internal.platform.ChromiumVerifierWin32;
import com.teamdev.jxbrowser.internal.platform.ChromiumVerifierWin64;
import com.teamdev.jxbrowser.os.Environment;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public final class ChromiumVerifiers {
    public static List<ChromiumVerifier> list() {
        ArrayList<ChromiumVerifier> result = new ArrayList<ChromiumVerifier>();
        if (Environment.isMac()) {
            ChromiumFiles.create("chromium-mac.info", "browsercore.app/Contents/MacOS/browsercore").ifPresent(chromiumFiles -> result.add(new ChromiumVerifierMac((ChromiumFiles)chromiumFiles)));
        }
        if (Environment.isLinux()) {
            if (Environment.isArm()) {
                ChromiumFiles.create("chromium-linux64-arm.info", "browsercore64").ifPresent(chromiumFiles -> result.add(new ChromiumVerifierLinux((ChromiumFiles)chromiumFiles)));
            } else {
                ChromiumFiles.create("chromium-linux64.info", "browsercore64").ifPresent(chromiumFiles -> result.add(new ChromiumVerifierLinux((ChromiumFiles)chromiumFiles)));
            }
        }
        if (Environment.isWindows()) {
            List<ChromiumVerifier> verifiers;
            ChromiumFiles.create("chromium-win32.info", "browsercore32.exe").ifPresent(files -> result.add(new ChromiumVerifierWin32((ChromiumFiles)files)));
            if (Environment.isWindows64()) {
                ChromiumFiles.create("chromium-win64.info", "browsercore64.exe").ifPresent(files -> result.add(new ChromiumVerifierWin64((ChromiumFiles)files)));
            }
            if (!(verifiers = result.stream().filter(ChromiumVerifier::archivePresent).sorted(Comparator.comparing(o -> o.files().executableFile().name(), Comparator.reverseOrder())).limit(1L).collect(Collectors.toList())).isEmpty()) {
                return verifiers;
            }
            result.sort(Comparator.comparing(o -> o.files().executableFile().name(), Comparator.reverseOrder()));
        }
        return result;
    }
}

