/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.ChromiumArchiveName;
import com.teamdev.jxbrowser.internal.ChromiumFile;
import com.teamdev.jxbrowser.internal.ChromiumFiles;
import com.teamdev.jxbrowser.internal.xz.XzExtractor;
import com.teamdev.jxbrowser.logging.Logger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public abstract class ChromiumVerifier {
    private final ChromiumFiles chromiumFiles;
    private final boolean archivePresent;

    public ChromiumVerifier(ChromiumFiles files, ChromiumArchiveName archiveName) {
        this.chromiumFiles = files;
        this.archivePresent = XzExtractor.findResourceURL(archiveName.value()).isPresent();
    }

    public boolean verify(Path chromiumDir) {
        for (ChromiumFile chromiumFile : this.chromiumFiles.list()) {
            Path file = chromiumDir.resolve(chromiumFile.name());
            Logger.debug("Verifying " + file + "...");
            if (!Files.exists(file, new LinkOption[0])) {
                Logger.debug("Verifying " + file + "... [FAIL] File does not exist");
                return false;
            }
            if (chromiumFile.length() != file.toFile().length()) {
                Logger.debug("Verifying " + file + "... [FAIL] File length mismatch");
                return false;
            }
            Logger.debug("Verifying " + file + "... [OK]");
        }
        return true;
    }

    public ChromiumFiles files() {
        return this.chromiumFiles;
    }

    boolean archivePresent() {
        return this.archivePresent;
    }
}

