/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.VersionInfo;
import com.teamdev.jxbrowser.internal.ChromiumFiles;
import com.teamdev.jxbrowser.internal.ChromiumProcess;
import com.teamdev.jxbrowser.internal.FileUtil;
import com.teamdev.jxbrowser.internal.ProcessDpiAwareness;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.platform.ExecutablePathResolverWin;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;

public final class ChromiumProcessWin
extends ChromiumProcess {
    public static final String PROCESS_NAME_WIN32 = "browsercore32.exe";
    public static final String PROCESS_NAME_WIN64 = "browsercore64.exe";

    ChromiumProcessWin(int port, Path chromiumDir, @Nullable ChromiumFiles chromiumFiles) {
        super(port, chromiumDir, new ExecutablePathResolverWin(chromiumDir, chromiumFiles));
    }

    @Override
    protected Collection<String> platformCommandLineArgs() {
        ArrayList<String> args = new ArrayList<String>();
        int awareness = ToolkitLibrary.getInstance(this.workingDir()).getProcessDpiAwareness();
        ProcessDpiAwareness dpiAwareness = ProcessDpiAwareness.from(awareness);
        if (dpiAwareness != null) {
            args.add("--dpi-awareness=" + dpiAwareness.toString());
        }
        Environment.win32UserAppDataLocalDir().ifPresent(appDataDir -> {
            String defaultDirectory = appDataDir.resolve("JxBrowser").resolve(VersionInfo.version()).resolve("CrashReports").toAbsolutePath().toString();
            String path = System.getProperty("jxbrowser.crash.dump.dir", defaultDirectory);
            File dir = new File(path);
            try {
                FileUtil.validateDirectory(dir);
                args.add("--crash-dump-dir=" + dir.getAbsolutePath());
            }
            catch (IOException e) {
                Logger.warn("Failed to access crash dump directory: " + e.getMessage());
            }
        });
        return args;
    }
}

