/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.internal.ChromiumProcess;
import com.teamdev.jxbrowser.internal.FileUtil;
import com.teamdev.jxbrowser.internal.platform.ExecutablePathResolverUnix;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;

public final class ChromiumProcessMac
extends ChromiumProcess {
    static final String PROCESS_NAME = "browsercore.app/Contents/MacOS/browsercore";

    ChromiumProcessMac(int port, Path chromiumDir) {
        super(port, chromiumDir, new ExecutablePathResolverUnix(chromiumDir, PROCESS_NAME));
    }

    @Override
    protected void preProcessRun(ProcessBuilder processBuilder, EngineOptions options) throws IOException {
        super.preProcessRun(processBuilder, options);
        FileUtil.restorePermissionsForFile(this.processFile());
        FileUtil.restorePermissionsForFile(this.helperProcessFile());
    }

    private Path helperProcessFile() {
        return this.workingDir().resolve("browsercore.app/Contents/Versions/Current/browsercore-helper.app/Contents/MacOS/browsercore-helper");
    }

    @Override
    protected Collection<String> platformCommandLineArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--disable-remote-core-animation");
        args.add("--use-mock-keychain");
        return args;
    }
}

