/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.logging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

final class ChromiumProcessLogger {
    ChromiumProcessLogger() {
    }

    void startLogging(Process process) {
        Thread thread = new Thread(() -> {
            try {
                String line;
                InputStream inputStream = process.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                BufferedReader input = new BufferedReader(inputStreamReader);
                while ((line = input.readLine()) != null) {
                    Logger.debug("[Chromium] {0}", line);
                }
                input.close();
            }
            catch (IOException e) {
                Logger.error("Failed to log chromium process output.", e);
            }
        }, "Chromium Process Logger");
        thread.setDaemon(true);
        thread.start();
    }
}

