/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.Language;
import com.teamdev.jxbrowser.engine.internal.ChromiumLibraryPatcher;
import com.teamdev.jxbrowser.internal.ChromiumProcess;
import com.teamdev.jxbrowser.internal.FileUtil;
import com.teamdev.jxbrowser.internal.platform.ExecutablePathResolverUnix;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class ChromiumProcessLinux
extends ChromiumProcess {
    static final String PROCESS_NAME = "browsercore64";
    private static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";

    ChromiumProcessLinux(int port, Path chromiumDir) {
        super(port, chromiumDir, new ExecutablePathResolverUnix(chromiumDir, PROCESS_NAME));
    }

    private static void configureLanguage(ProcessBuilder processBuilder, Language language) {
        Map<String, String> environment = processBuilder.environment();
        environment.put("LANGUAGE", language.toString());
    }

    public static void patchLinuxLibraryPath(String workingDir, ProcessBuilder processBuilder) {
        Map<String, String> environment = processBuilder.environment();
        String newValue = workingDir;
        if (environment.containsKey(LD_LIBRARY_PATH)) {
            newValue = newValue + ':' + environment.get(LD_LIBRARY_PATH);
        }
        environment.put(LD_LIBRARY_PATH, newValue);
    }

    private static void patchSystemLinuxLibraries(String workingDir) {
        ChromiumLibraryPatcher patcher = new ChromiumLibraryPatcher(workingDir);
        patcher.patchLibrary("libudev.so.0", "libudev.so.");
        patcher.patchLibrary("libgcrypt.so.11", "libgcrypt.so.");
        patcher.patchLibrary("libcrypto.so.1.0.0", "libcrypto.so.");
    }

    @Override
    protected Collection<String> platformCommandLineArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--no-zygote");
        return args;
    }

    @Override
    protected void preProcessRun(ProcessBuilder processBuilder, EngineOptions options) throws IOException {
        super.preProcessRun(processBuilder, options);
        String workingDir = this.workingDir().toAbsolutePath().toString();
        ChromiumProcessLinux.patchLinuxLibraryPath(workingDir, processBuilder);
        ChromiumProcessLinux.patchSystemLinuxLibraries(workingDir);
        ChromiumProcessLinux.configureLanguage(processBuilder, options.language());
        FileUtil.restorePermissionsForFile(this.processFile());
    }
}

