/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.Language;
import com.teamdev.jxbrowser.engine.ProprietaryFeature;
import com.teamdev.jxbrowser.event.Observable;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.event.internal.ObservableHelper;
import com.teamdev.jxbrowser.internal.ChromiumFiles;
import com.teamdev.jxbrowser.internal.ChromiumProcessException;
import com.teamdev.jxbrowser.internal.ChromiumProcessLinux;
import com.teamdev.jxbrowser.internal.ChromiumProcessLogger;
import com.teamdev.jxbrowser.internal.ChromiumProcessMac;
import com.teamdev.jxbrowser.internal.ChromiumProcessWin;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.ExecutablePathResolver;
import com.teamdev.jxbrowser.internal.ExitCode;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.event.ChromiumProcessEvent;
import com.teamdev.jxbrowser.internal.event.ChromiumProcessStartFailed;
import com.teamdev.jxbrowser.internal.event.ChromiumProcessTerminated;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class ChromiumProcess
extends CloseableImpl<ChromiumProcess>
implements Observable<ChromiumProcessEvent> {
    static final String SWITCH_PREFIX = "--";
    private static final String GOOGLE_API_KEY = "GOOGLE_API_KEY";
    private static final String GOOGLE_DEFAULT_CLIENT_ID = "GOOGLE_DEFAULT_CLIENT_ID";
    private static final String GOOGLE_DEFAULT_CLIENT_SECRET = "GOOGLE_DEFAULT_CLIENT_SECRET";
    private static final String AUTOPLAY_POLICY_NO_USER_GESTURE_REQUIRED = "no-user-gesture-required";
    private final int port;
    private final Path processFile;
    private final Path workingDir;
    private final ObservableHelper<ChromiumProcessEvent> observable;
    private Process process;
    private ExitCode exitCode;
    private ExecutorService chromiumProcessService;

    public static ChromiumProcess create(int port, Path chromiumDir, @Nullable ChromiumFiles chromiumFiles) {
        if (Environment.isWindows()) {
            return new ChromiumProcessWin(port, chromiumDir, chromiumFiles);
        }
        if (Environment.isMac()) {
            return new ChromiumProcessMac(port, chromiumDir);
        }
        if (Environment.isLinux() && Environment.is64Bit()) {
            return new ChromiumProcessLinux(port, chromiumDir);
        }
        throw new IllegalStateException("Unsupported operating system.");
    }

    ChromiumProcess(int port, Path chromiumDir, ExecutablePathResolver resolver) {
        this.port = port;
        this.workingDir = chromiumDir;
        this.processFile = resolver.resolve().orElseThrow(() -> new IllegalStateException("The " + chromiumDir + " directory doesn't include the required Chromium binaries."));
        this.observable = new ObservableHelper();
        this.chromiumProcessService = Executors.newFixedThreadPool(1, runnable -> {
            Thread chromiumProcessThread = new Thread(runnable);
            chromiumProcessThread.setName("Chromium Process Thread");
            return chromiumProcessThread;
        });
    }

    @Override
    public void close() {
        while (!this.chromiumProcessService.isTerminated()) {
            try {
                this.chromiumProcessService.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignore) {
                Logger.debug("Awaiting process termination: the current thread has been interrupted.");
            }
        }
        super.close();
    }

    Path workingDir() {
        return this.workingDir;
    }

    Path processFile() {
        return this.processFile;
    }

    @Override
    public <E extends ChromiumProcessEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.observable.on(eventClass, observer);
    }

    protected abstract Collection<String> platformCommandLineArgs();

    private Collection<String> commandLineArgs(EngineOptions engineOptions) {
        ArrayList<String> result = new ArrayList<String>();
        Preconditions.checkArgument(this.port != 0);
        result.add("--port=" + this.port);
        ToolkitLibrary toolkitLibrary = ToolkitLibrary.getInstance(this.workingDir);
        result.add("--pid=" + toolkitLibrary.getCurrentProcessId());
        engineOptions.userAgent().ifPresent(userAgent -> result.add("--user-agent=" + userAgent));
        engineOptions.ppapiFlashPath().ifPresent(path -> result.add("--ppapi-flash-path=" + path.toAbsolutePath()));
        engineOptions.ppapiFlashVersion().ifPresent(version -> result.add("--ppapi-flash-version=" + version));
        Language language = engineOptions.language();
        result.add("--lang=" + (Object)((Object)language));
        engineOptions.remoteDebuggingPort().ifPresent(remoteDebuggingPort -> result.add("--remote-debugging-port=" + remoteDebuggingPort));
        engineOptions.diskCacheSize().ifPresent(diskCacheSize -> result.add("--disk-cache-size=" + diskCacheSize));
        if (engineOptions.isIncognitoEnabled()) {
            result.add("--incognito");
        }
        if (engineOptions.isTouchMenuDisabled()) {
            result.add("--disable-touch-menu");
        }
        if (engineOptions.isProprietaryFeatureEnabled(ProprietaryFeature.WIDEVINE)) {
            result.add("--enable-widevine");
        }
        if (engineOptions.isProprietaryFeatureEnabled(ProprietaryFeature.AAC)) {
            result.add("--enable-aac-codec");
        }
        if (engineOptions.isProprietaryFeatureEnabled(ProprietaryFeature.H_264)) {
            result.add("--enable-h264-codec");
        }
        if (engineOptions.isSandboxDisabled()) {
            result.add("--no-sandbox");
        }
        if (engineOptions.isWebSecurityDisabled()) {
            result.add("--disable-web-security");
        }
        if (engineOptions.isFileAccessFromFilesAllowed()) {
            result.add("--allow-file-access-from-files");
        }
        if (engineOptions.isAutoplayEnabled()) {
            result.add("--autoplay-policy=no-user-gesture-required");
        }
        if (engineOptions.isGpuDisabled()) {
            result.add("--disable-gpu");
        }
        if (!engineOptions.secureOriginWhiteList().isEmpty()) {
            result.add("--unsafely-treat-insecure-origin-as-secure=" + String.join((CharSequence)",", engineOptions.secureOriginWhiteList()));
        }
        result.add("--overscroll-history-navigation=0");
        engineOptions.passwordStore().ifPresent(passwordStore -> result.add("--password-store=" + passwordStore.value()));
        String scaleFactorSwitch = "--force-device-scale-factor=";
        for (String switcher : engineOptions.switches()) {
            if (!switcher.startsWith(scaleFactorSwitch)) continue;
            String scaleFactorValue = switcher.substring(scaleFactorSwitch.length());
            try {
                if (Double.compare(Double.parseDouble(scaleFactorValue), 1.0) < 0) continue;
                System.setProperty("jxbrowser.force.device.scale.factor", scaleFactorValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        result.add("--user-data-dir=" + engineOptions.userDataDir().toAbsolutePath());
        result.add("--disable-shadow-logging");
        if (Environment.isWindows()) {
            result.add("--disable-fill-background");
        }
        result.addAll(this.platformCommandLineArgs());
        result.addAll(engineOptions.switches());
        return result;
    }

    protected void preProcessRun(ProcessBuilder processBuilder, EngineOptions options) throws IOException {
    }

    public void start(EngineOptions engineOptions) {
        if (this.isStarted()) {
            return;
        }
        this.startInternal(engineOptions);
    }

    private void startInternal(EngineOptions engineOptions) {
        Future<?> task = this.chromiumProcessService.submit(() -> {
            try {
                Collection<String> args = this.commandLineArgs(engineOptions);
                Logger.debug("Starting chromium process...");
                ArrayList<String> command = new ArrayList<String>();
                command.add(this.processFile.toAbsolutePath().toString());
                command.addAll(args);
                ProcessBuilder processBuilder = new ProcessBuilder(command);
                processBuilder.directory(this.workingDir.toFile());
                processBuilder.redirectErrorStream(true);
                this.configGoogleApiKeys(engineOptions, processBuilder);
                this.preProcessRun(processBuilder, engineOptions);
                StringBuilder commandLine = new StringBuilder();
                for (String commandItem : command) {
                    commandLine.append(commandItem);
                    commandLine.append(' ');
                }
                Logger.debug(commandLine.toString());
                this.process = processBuilder.start();
                Logger.debug("Starting chromium process... [OK]");
            }
            catch (IOException e) {
                Logger.error("Starting chromium process... [FAILED]", e);
                this.observable.notifyObservers(new ChromiumProcessStartFailed());
                throw new ChromiumProcessException(e);
            }
        });
        try {
            task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ChromiumProcessException(e);
        }
        this.chromiumProcessService.execute(() -> {
            try {
                ChromiumProcessLogger processLogger = new ChromiumProcessLogger();
                processLogger.startLogging(this.process);
                this.exitCode = ExitCode.of(this.process.waitFor());
                Logger.debug("Chromium process exit code: " + this.exitCode.value());
                this.process = null;
                this.observable.notifyObservers(new ChromiumProcessTerminated(this.exitCode));
            }
            catch (InterruptedException ignore) {
                Logger.debug("The chromium process thread has been interrupted.");
            }
            finally {
                this.chromiumProcessService.shutdown();
            }
        });
    }

    private void configGoogleApiKeys(EngineOptions engineOptions, ProcessBuilder processBuilder) {
        engineOptions.googleApiKey().ifPresent(googleApiKey -> processBuilder.environment().put(GOOGLE_API_KEY, (String)googleApiKey));
        engineOptions.googleDefaultClientId().ifPresent(googleDefaultClientId -> processBuilder.environment().put(GOOGLE_DEFAULT_CLIENT_ID, (String)googleDefaultClientId));
        engineOptions.googleDefaultClientSecret().ifPresent(googleDefaultClientSecret -> processBuilder.environment().put(GOOGLE_DEFAULT_CLIENT_SECRET, (String)googleDefaultClientSecret));
    }

    public boolean isStarted() {
        return this.process != null;
    }

    public ExitCode exitCode() {
        return this.exitCode;
    }
}

