/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.ChromiumLocale;
import java.util.Optional;

public final class ChromiumLanguage {
    private static final ChromiumLocale chromiumLocale = ChromiumLocale.create();
    private final String code;
    private final String country;

    public static ChromiumLanguage of(String code, String country) {
        return new ChromiumLanguage(code, country);
    }

    public static ChromiumLanguage of(String code) {
        return new ChromiumLanguage(code, null);
    }

    private ChromiumLanguage(String code, String country) {
        this.code = code;
        this.country = country;
    }

    public String code() {
        return this.code;
    }

    public Optional<String> country() {
        return Optional.ofNullable(this.country);
    }

    public String toString() {
        return chromiumLocale.localeLanguage(this);
    }
}

