/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.ChromiumFile;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;

public final class ChromiumFiles {
    private final List<ChromiumFile> files;
    private final ChromiumFile executableFile;

    public static Optional<ChromiumFiles> create(String propertyFileName, String executableName) {
        URL resourceUrl = ChromiumFiles.class.getResource(propertyFileName);
        if (resourceUrl != null) {
            return Optional.of(new ChromiumFiles(resourceUrl, executableName));
        }
        return Optional.empty();
    }

    private ChromiumFiles(URL resourceUrl, String executableName) {
        Properties properties = new Properties();
        try (InputStream inputStream = resourceUrl.openStream();){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load properties file:" + resourceUrl, e);
        }
        this.files = properties.stringPropertyNames().stream().map(propertyName -> new ChromiumFile((String)propertyName, Long.parseLong(properties.getProperty((String)propertyName)))).collect(Collectors.toList());
        this.executableFile = this.files.stream().filter(chromiumFile -> chromiumFile.name().equals(executableName)).findFirst().orElseThrow(() -> new IllegalArgumentException("The file list does not contain the executable file: " + executableName));
    }

    public List<ChromiumFile> list() {
        return new ArrayList<ChromiumFile>(this.files);
    }

    public ChromiumFile executableFile() {
        return this.executableFile;
    }
}

