/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.ChromiumArchiveName;
import com.teamdev.jxbrowser.internal.ChromiumExtractorException;
import com.teamdev.jxbrowser.internal.xz.XzExtractor;
import com.teamdev.jxbrowser.logging.Logger;
import java.io.FileNotFoundException;
import java.net.URL;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ChromiumExtractor {
    public static void extract(Path chromiumDir) {
        Logger.debug("Finding Chromium binaries in JARs...");
        List<ChromiumArchiveName> archiveNames = ChromiumArchiveName.list();
        for (ChromiumArchiveName archiveName : archiveNames) {
            Logger.debug("Finding " + (Object)((Object)archiveName) + "...");
            Optional<URL> resourceURL = XzExtractor.findResourceURL(archiveName.value());
            if (!resourceURL.isPresent()) {
                Logger.debug("Finding " + (Object)((Object)archiveName) + "... [FAIL]");
                continue;
            }
            AccessController.doPrivileged(() -> {
                Logger.debug("Extracting archive...");
                long time = System.currentTimeMillis();
                XzExtractor.extract(chromiumDir, archiveName);
                long extractionTime = System.currentTimeMillis() - time;
                Logger.debug("Extracting archive... [OK] " + extractionTime + "ms");
                return null;
            });
            return;
        }
        throw new ChromiumExtractorException("Failed to extract Chromium binaries into " + chromiumDir.toAbsolutePath(), new FileNotFoundException(archiveNames.stream().map(ChromiumArchiveName::value).collect(Collectors.joining(", "))));
    }

    private ChromiumExtractor() {
    }
}

