/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.JniLibrary;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.os.Environment;
import java.awt.Window;
import java.io.File;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;

public final class AWTHelperLibrary
extends JniLibrary {
    private static final Map<String, AWTHelperLibrary> libraryPathToAwtHelperLibraryMap = new HashMap<String, AWTHelperLibrary>();

    public static AWTHelperLibrary getInstance(File dir) {
        Preconditions.checkNotNull(dir);
        String absolutePath = dir.getAbsolutePath();
        if (!libraryPathToAwtHelperLibraryMap.containsKey(absolutePath)) {
            if (Environment.isWindows() || Environment.isLinux()) {
                AccessController.doPrivileged(() -> {
                    AWTHelperLibrary.ensureRequiredLibrariesAreLoaded();
                    return null;
                });
            }
            libraryPathToAwtHelperLibraryMap.put(absolutePath, new AWTHelperLibrary(absolutePath));
        }
        return libraryPathToAwtHelperLibraryMap.get(absolutePath);
    }

    private AWTHelperLibrary(String dir) {
        super("awt_helper", dir);
    }

    public native long getWindowHandle(Window var1);

    private static void ensureRequiredLibrariesAreLoaded() {
        try {
            System.loadLibrary("awt");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        try {
            System.loadLibrary("jawt");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }
}

