/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.RenderProcess;
import com.teamdev.jxbrowser.browser.internal.RenderProcesses;
import com.teamdev.jxbrowser.event.internal.EventSource;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.frame.internal.callback.CreateFrameCallback;
import com.teamdev.jxbrowser.frame.internal.callback.DeleteFrameCallback;
import com.teamdev.jxbrowser.frame.internal.rpc.CreateFrame;
import com.teamdev.jxbrowser.frame.internal.rpc.DeleteFrame;
import com.teamdev.jxbrowser.frame.internal.rpc.FramesStub;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.RenderProcessId;
import com.teamdev.jxbrowser.internal.rpc.stream.EventSourceProvider;

public final class Frames
extends CloseableImpl<Frames>
implements EventSourceProvider {
    private final NewServiceConnection<FramesStub> rpc;

    public Frames(BrowserImpl browser) {
        this.rpc = new NewServiceConnection<FramesStub>(browser.id(), browser.engine().connection(), FramesStub::new);
        this.rpc.set(CreateFrameCallback.class, params -> {
            RenderProcessId renderProcessId = params.getRenderProcessId();
            RenderProcesses renderProcesses = browser.engine().renderProcesses();
            renderProcesses.renderProcess(renderProcessId).ifPresent(renderProcess -> {
                FrameImpl frame = new FrameImpl(browser, (RenderProcess)renderProcess, params.getFrameId());
                frame.register();
                browser.notifyObserversAsync(params);
            });
            return CreateFrame.Response.newBuilder().build();
        });
        this.rpc.set(DeleteFrameCallback.class, params -> {
            FrameImpl.with(params.getFrameId()).ifPresent(frame -> {
                frame.close();
                browser.notifyObserversAsync(params, frame::unregister);
            });
            return DeleteFrame.Response.newBuilder().build();
        });
    }

    @Override
    public void close() {
        this.rpc.close();
        super.close();
    }

    @Override
    public EventSource eventSource() {
        return this.rpc;
    }
}

