/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.RenderProcess;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Empty;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.dom.Document;
import com.teamdev.jxbrowser.dom.PointInspection;
import com.teamdev.jxbrowser.dom.internal.DomContext;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.dom.internal.rpc.StorageType;
import com.teamdev.jxbrowser.frame.EditorCommand;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.frame.LoadDataParams;
import com.teamdev.jxbrowser.frame.LoadHtmlParams;
import com.teamdev.jxbrowser.frame.WebStorage;
import com.teamdev.jxbrowser.frame.internal.WebStorageImpl;
import com.teamdev.jxbrowser.frame.internal.callback.GetObjectTypeCallback;
import com.teamdev.jxbrowser.frame.internal.callback.HasMethodCallback;
import com.teamdev.jxbrowser.frame.internal.callback.InjectCssCallback;
import com.teamdev.jxbrowser.frame.internal.callback.InjectJsCallback;
import com.teamdev.jxbrowser.frame.internal.callback.InvokeMethodCallback;
import com.teamdev.jxbrowser.frame.internal.rpc.EditorCommandName;
import com.teamdev.jxbrowser.frame.internal.rpc.ExecuteJavaScriptRequest;
import com.teamdev.jxbrowser.frame.internal.rpc.FrameStub;
import com.teamdev.jxbrowser.frame.internal.rpc.GetObjectType;
import com.teamdev.jxbrowser.frame.internal.rpc.HasMethod;
import com.teamdev.jxbrowser.frame.internal.rpc.InjectCss;
import com.teamdev.jxbrowser.frame.internal.rpc.InjectJs;
import com.teamdev.jxbrowser.frame.internal.rpc.InvokeMethod;
import com.teamdev.jxbrowser.frame.internal.rpc.LoadDataRequest;
import com.teamdev.jxbrowser.frame.internal.rpc.LoadHtmlRequest;
import com.teamdev.jxbrowser.frame.internal.rpc.LoadUrlRequest;
import com.teamdev.jxbrowser.frame.internal.rpc.Location;
import com.teamdev.jxbrowser.frame.internal.rpc.SpellCheckCompleted;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.ThreadUtil;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.DefaultResponse;
import com.teamdev.jxbrowser.internal.rpc.FrameId;
import com.teamdev.jxbrowser.internal.rpc.FrameIdList;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.RpcCallback;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.internal.util.ReflectionUtil;
import com.teamdev.jxbrowser.internal.util.TypeUtil;
import com.teamdev.jxbrowser.js.JsAccessible;
import com.teamdev.jxbrowser.js.JsFunctionCallback;
import com.teamdev.jxbrowser.js.Json;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.JsonImpl;
import com.teamdev.jxbrowser.js.internal.rpc.JsError;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import com.teamdev.jxbrowser.js.internal.rpc.ReturnValue;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.ui.Point;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class FrameImpl
extends CloseableImpl<FrameImpl>
implements Frame {
    private static final IdMap<FrameId, FrameImpl> frameIdToFrameMap = new IdMap();
    private final FrameId id;
    private final JsonImpl json;
    private final BrowserImpl browser;
    private final JsContext jsContext;
    private final DomContext domContext;
    private final RenderProcess renderProcess;
    private final NewServiceConnection<FrameStub> rpc;
    private final WebStorageImpl localStorage;
    private final WebStorageImpl sessionStorage;

    public static Optional<FrameImpl> with(FrameId frameId) {
        Preconditions.checkNotNull(frameId);
        Logger.debug("Finding frame with id: " + frameId);
        return frameIdToFrameMap.find(frameId);
    }

    public FrameImpl(BrowserImpl browser, RenderProcess renderProcess, FrameId frameId) {
        Preconditions.checkNotNull(browser);
        Preconditions.checkNotNull(renderProcess);
        Preconditions.checkNotNull(frameId);
        this.id = frameId;
        this.browser = browser;
        this.renderProcess = renderProcess;
        Connection connection = renderProcess.connection();
        this.localStorage = new WebStorageImpl(connection, StorageType.LOCAL, frameId);
        this.sessionStorage = new WebStorageImpl(connection, StorageType.SESSION, frameId);
        this.json = new JsonImpl(this);
        this.jsContext = new JsContext(this);
        this.domContext = new DomContext(connection, this);
        this.rpc = new NewServiceConnection<FrameStub>(frameId, connection, FrameStub::new);
        this.rpc.set(HasMethodCallback.class, this::processCallback);
        this.rpc.set(GetObjectTypeCallback.class, this::processCallback);
        this.rpc.set(InvokeMethodCallback.class, this::processCallback);
        this.rpc.set(InjectCssCallback.class, this::processCallback);
        this.rpc.set(InjectJsCallback.class, this::processCallback);
        this.rpc.on(SpellCheckCompleted.class, browser::notifyObservers);
        renderProcess.addFrame(this);
    }

    private InjectJs.Response processCallback(InjectJs.Request params) {
        Optional<com.teamdev.jxbrowser.browser.callback.InjectJsCallback> callback = this.browser.get(com.teamdev.jxbrowser.browser.callback.InjectJsCallback.class);
        if (!callback.isPresent()) {
            return DefaultResponse.injectJs();
        }
        try {
            return (InjectJs.Response)callback.get().on(params);
        }
        catch (Exception e) {
            FrameImpl.reportError(e, InjectJsCallback.class);
            return DefaultResponse.injectJs();
        }
    }

    private InjectCss.Response processCallback(InjectCss.Request params) {
        Optional<com.teamdev.jxbrowser.browser.callback.InjectCssCallback> callback = this.browser.get(com.teamdev.jxbrowser.browser.callback.InjectCssCallback.class);
        if (!callback.isPresent()) {
            return DefaultResponse.injectCss();
        }
        try {
            return (InjectCss.Response)callback.get().on(params);
        }
        catch (Exception e) {
            FrameImpl.reportError(e, InjectCssCallback.class);
            return DefaultResponse.injectCss();
        }
    }

    private InvokeMethod.Response processCallback(InvokeMethod.Request params) {
        Optional<Object> object = this.jsContext.javaObject(params.getObjectProxyId());
        if (object.isPresent()) {
            try {
                String methodName = params.getMethodName();
                Object result = object.get() instanceof JsFunctionCallback ? this.invokeCallbackMethod((JsFunctionCallback)object.get(), params.getArgList()) : (methodName.equalsIgnoreCase("Symbol.toPrimitive") ? this.handleSymbolToPrimitive(object.get(), params.getArgList()) : this.invokeObjectMethod(object.get(), methodName, params.getArgList()));
                return this.invokeMethodResponse(this.jsContext.toValue(result));
            }
            catch (Exception e) {
                String errorMessage;
                if (e instanceof InvocationTargetException) {
                    Throwable cause = e.getCause();
                    errorMessage = cause.toString() + " in " + cause.getStackTrace()[0];
                } else {
                    errorMessage = e.toString() + " in " + e.getStackTrace()[0];
                }
                return this.invokeMethodResponse(errorMessage);
            }
        }
        return this.invokeMethodResponse("No such java object");
    }

    private Object handleSymbolToPrimitive(Object object, List<JsValue> args) {
        Preconditions.checkArgument(args.size() == 1);
        JsValue hint = args.get(0);
        Preconditions.checkArgument(hint.getValueCase() == JsValue.ValueCase.STRING_VALUE);
        String hintValue = hint.getStringValue();
        if (hintValue.equalsIgnoreCase("number")) {
            return Double.NaN;
        }
        if (hintValue.equalsIgnoreCase("string")) {
            return "[object " + object.getClass().getName() + "]";
        }
        if (hintValue.equalsIgnoreCase("default")) {
            return "[object " + object.getClass().getName() + "]";
        }
        throw new IllegalArgumentException("Unsupported 'Symbol.toPrimitive' hint: " + hintValue);
    }

    private InvokeMethod.Response invokeMethodResponse(JsValue value) {
        return InvokeMethod.Response.newBuilder().setReturnValue(ReturnValue.newBuilder().setJsValue(value).build()).build();
    }

    private InvokeMethod.Response invokeMethodResponse(String message) {
        return InvokeMethod.Response.newBuilder().setReturnValue(ReturnValue.newBuilder().setJsError(JsError.newBuilder().setMessage(message).build()).build()).build();
    }

    private HasMethod.Response processCallback(HasMethod.Request params) {
        Optional<Object> object = this.jsContext.javaObject(params.getObjectProxyId());
        if (object.isPresent()) {
            if (object.get() instanceof JsFunctionCallback) {
                return HasMethod.Response.newBuilder().setHas(Empty.newBuilder().build()).build();
            }
            Optional<Method> optionalMethod = ReflectionUtil.findPublicMethodByName(object.get().getClass(), params.getMethodName());
            if (optionalMethod.isPresent()) {
                if (this.isAccessibleFromJs(optionalMethod.get())) {
                    return HasMethod.Response.newBuilder().setHas(Empty.newBuilder().build()).build();
                }
                return this.hasMethodResponse("Access denied");
            }
            return this.hasMethodResponse("No such method");
        }
        return this.hasMethodResponse("No such java object");
    }

    private HasMethod.Response hasMethodResponse(String message) {
        return HasMethod.Response.newBuilder().setError(JsError.newBuilder().setMessage(message).build()).build();
    }

    private GetObjectType.Response processCallback(GetObjectType.Request params) {
        Optional<Object> object = this.jsContext.javaObject(params.getObjectProxyId());
        if (object.isPresent()) {
            try {
                String result = object.get().getClass().getName();
                return GetObjectType.Response.newBuilder().setObjectType(result).build();
            }
            catch (Exception e) {
                Logger.error("Failed to get class name", e);
                return this.getObjectTypeResponse(e.getMessage());
            }
        }
        return this.getObjectTypeResponse("No such java object");
    }

    private GetObjectType.Response getObjectTypeResponse(String message) {
        return GetObjectType.Response.newBuilder().setError(JsError.newBuilder().setMessage(message).build()).build();
    }

    private static void reportError(Throwable throwable, Class<? extends Callback> callbackClass) {
        ThreadUtil.reportException(throwable);
        Logger.error("An exception has been thrown during {0} execution.", callbackClass.getSimpleName(), throwable);
    }

    public JsContext jsContext() {
        return this.jsContext;
    }

    public DomContext domContext() {
        return this.domContext;
    }

    @Override
    public RenderProcess renderProcess() {
        return this.renderProcess;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.localStorage.close();
        this.sessionStorage.close();
        this.domContext.close();
        this.jsContext.close();
        this.renderProcess.removeFrame(this);
        super.close();
    }

    public FrameId id() {
        return this.id;
    }

    @Override
    public Browser browser() {
        return this.browser;
    }

    @Override
    public boolean isMain() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isMainFrame, this.id)).getValue();
    }

    @Override
    public String name() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getName, this.id)).getValue();
    }

    @Override
    public String html() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getHtml, this.id)).getValue();
    }

    @Override
    public void loadUrl(String url) {
        Preconditions.checkNotNullEmptyOrBlank(url);
        this.checkNotClosed();
        LoadUrlRequest request = LoadUrlRequest.newBuilder().setFrameId(this.id).setUrl(url).build();
        this.rpc.invoke(this.rpc.stub()::loadUrl, request);
    }

    @Override
    public void loadHtml(String html) {
        Preconditions.checkNotNullEmptyOrBlank(html);
        this.loadHtml(LoadHtmlParams.newBuilder(html).build());
    }

    @Override
    public void loadHtml(LoadHtmlParams params) {
        Preconditions.checkNotNull(params);
        this.checkNotClosed();
        LoadHtmlRequest request = Wrappers.unwrap(params, LoadHtmlRequest.class).toBuilder().setFrameId(this.id).build();
        this.rpc.invoke(this.rpc.stub()::loadHtml, request);
    }

    @Override
    public void loadData(LoadDataParams params) {
        Preconditions.checkNotNull(params);
        this.checkNotClosed();
        LoadDataRequest request = Wrappers.unwrap(params, LoadDataRequest.class).toBuilder().setFrameId(this.id).build();
        this.rpc.invoke(this.rpc.stub()::loadData, request);
    }

    @Override
    public <T> T executeJavaScript(String javaScript) {
        return this.executeJavaScript(javaScript, false);
    }

    @Override
    public void executeJavaScript(String javaScript, final Consumer<?> callback) {
        Preconditions.checkNotNull(javaScript);
        Preconditions.checkArgument(!javaScript.trim().isEmpty());
        Preconditions.checkNotNull(callback);
        this.checkNotClosed();
        ExecuteJavaScriptRequest request = ExecuteJavaScriptRequest.newBuilder().setFrameId(this.id).setJavaScript(javaScript).build();
        this.rpc.invokeAsync(this.rpc.stub()::executeJavaScript, request, new RpcCallback<JsValue>(){

            @Override
            public void onNext(JsValue value) {
                callback.accept(FrameImpl.this.jsContext.toObject(value));
            }
        });
    }

    public <T> T executeJavaScript(String javaScript, boolean userGesture) {
        Preconditions.checkNotNull(javaScript);
        Preconditions.checkArgument(!javaScript.trim().isEmpty());
        this.checkNotClosed();
        ExecuteJavaScriptRequest request = ExecuteJavaScriptRequest.newBuilder().setFrameId(this.id).setJavaScript(javaScript).setUserGesture(userGesture).build();
        return this.jsContext.toObject((JsValue)this.rpc.invoke(this.rpc.stub()::executeJavaScript, request));
    }

    @Override
    public boolean execute(EditorCommand command) {
        Preconditions.checkNotNull(command);
        this.checkNotClosed();
        com.teamdev.jxbrowser.frame.internal.rpc.EditorCommand request = com.teamdev.jxbrowser.frame.internal.rpc.EditorCommand.newBuilder().setCommandName(EditorCommandName.newBuilder().setFrameId(this.id).setCommandName(command.name().value()).build()).setCommandValue(command.value()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::executeEditorCommand, request)).getValue();
    }

    @Override
    public boolean isCommandEnabled(EditorCommand.Name commandName) {
        this.checkNotClosed();
        EditorCommandName request = EditorCommandName.newBuilder().setFrameId(this.id).setCommandName(commandName.value()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isEditorCommandEnabled, request)).getValue();
    }

    @Override
    public void print() {
        this.checkNotClosed();
        this.browser.print(this.id);
    }

    @Override
    public Json json() {
        this.checkNotClosed();
        return this.json;
    }

    @Override
    public WebStorage localStorage() {
        this.checkNotClosed();
        return this.localStorage;
    }

    @Override
    public WebStorage sessionStorage() {
        this.checkNotClosed();
        return this.sessionStorage;
    }

    @Override
    public boolean hasSelection() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::hasSelection, this.id)).getValue();
    }

    @Override
    public String selectionAsText() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getSelectionAsText, this.id)).getValue();
    }

    @Override
    public String selectionAsHtml() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getSelectionAsMarkup, this.id)).getValue();
    }

    @Override
    public Optional<Document> document() {
        this.checkNotClosed();
        NodeInfo response = (NodeInfo)this.rpc.invoke(this.rpc.stub()::getDocument, this.id);
        if (response.getNodeId().getValue() != 0) {
            return Optional.of(this.domContext.toDocument(response));
        }
        return Optional.empty();
    }

    @Override
    public PointInspection inspect(Point location) {
        Preconditions.checkNotNull(location);
        this.checkNotClosed();
        Location request = Location.newBuilder().setFrameId(this.id).setPoint(Wrappers.unwrap(location, com.teamdev.jxbrowser.ui.internal.rpc.Point.class)).build();
        return (PointInspection)this.rpc.invoke(this.rpc.stub()::inspect, request);
    }

    @Override
    public PointInspection inspect(int x, int y) {
        return this.inspect(Point.of(x, y));
    }

    @Override
    public Optional<Frame> parent() {
        this.checkNotClosed();
        return FrameImpl.with((FrameId)this.rpc.invoke(this.rpc.stub()::getParentFrame, this.id)).map(frame -> frame);
    }

    @Override
    public List<Frame> children() {
        this.checkNotClosed();
        ArrayList result = new ArrayList();
        ((FrameIdList)this.rpc.invoke(this.rpc.stub()::getChildren, this.id)).getFrameIdList().forEach(frameId -> result.add(FrameImpl.with(frameId).orElseThrow(IllegalStateException::new)));
        return Collections.unmodifiableList(result);
    }

    public void unregister() {
        frameIdToFrameMap.remove(this.id);
    }

    void register() {
        frameIdToFrameMap.put(this.id, this);
    }

    @Nullable
    private Object invokeCallbackMethod(JsFunctionCallback callback, List<JsValue> args) {
        Object[] javaParams = new Object[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            javaParams[i] = this.jsContext.toObject(args.get(i));
        }
        return callback.invoke(javaParams);
    }

    private static boolean match(Class<?>[] methodParamTypes, List<Object> params) {
        if (params.size() != methodParamTypes.length) {
            return false;
        }
        Iterator<Object> iterator = params.iterator();
        for (Class<?> methodParamType : methodParamTypes) {
            Object param = iterator.next();
            if (TypeUtil.isAssignable(methodParamType, param)) continue;
            return false;
        }
        return true;
    }

    private static Object[] toMethodParams(Class<?>[] methodParamTypes, List<Object> params) {
        Object[] result = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            result[i] = TypeUtil.toCompatibleType(params.get(i), methodParamTypes[i]);
        }
        return result;
    }

    @Nullable
    private Object invokeObjectMethod(Object object, String methodName, List<JsValue> args) throws InvocationTargetException, IllegalAccessException {
        List<Object> params = args.stream().map(this.jsContext::toObject).collect(Collectors.toList());
        Set<Method> methods = ReflectionUtil.findPublicMethods(object.getClass(), method -> methodName.equals(method.getName()) && this.isAccessibleFromJs((Method)method) && FrameImpl.match(method.getParameterTypes(), params));
        if (methods.size() > 1) {
            throw new IllegalArgumentException(FrameImpl.errorMessage(methods));
        }
        if (methods.isEmpty()) {
            throw new IllegalArgumentException(this.errorMessage(methodName, args));
        }
        Method method2 = methods.iterator().next();
        return method2.invoke(object, FrameImpl.toMethodParams(method2.getParameterTypes(), params));
    }

    private static String errorMessage(Set<Method> satisfiedMethods) {
        StringBuilder builder = new StringBuilder("Method invocation failed. Several methods with a suitable signature are found.");
        satisfiedMethods.forEach(method -> builder.append(String.format("%n\t%s", method)));
        return builder.toString();
    }

    private String errorMessage(String methodName, List<JsValue> args) {
        StringBuilder stringBuilder = new StringBuilder("Unsupported method signature: ");
        stringBuilder.append(methodName);
        stringBuilder.append("(");
        Iterator<JsValue> iterator = args.iterator();
        while (iterator.hasNext()) {
            JsValue arg = iterator.next();
            switch (arg.getValueCase()) {
                case BOOL_VALUE: {
                    stringBuilder.append("Object|Boolean|boolean");
                    break;
                }
                case NUMBER_VALUE: {
                    stringBuilder.append("Object|Number|Double|double");
                    break;
                }
                case STRING_VALUE: {
                    stringBuilder.append("Object|String");
                    break;
                }
                case NODE_INFO: 
                case OBJECT_ID_VALUE: 
                case OBJECT_PROXY_ID_VALUE: {
                    stringBuilder.append("Object");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported JsValue: " + arg);
                }
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private boolean isAccessibleFromJs(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        return method.isAnnotationPresent(JsAccessible.class) || method.getDeclaringClass().isAnnotationPresent(JsAccessible.class) || System.getProperties().containsKey("jxbrowser.jsaccessible.off");
    }
}

