/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame;

import com.teamdev.jxbrowser.frame.internal.rpc.LoadHtmlRequest;
import com.teamdev.jxbrowser.internal.util.Preconditions;

public interface LoadHtmlParams {
    public static Builder newBuilder(String html) {
        Preconditions.checkNotNull(html);
        return new Builder(html);
    }

    default public String html() {
        return ((LoadHtmlRequest)this).getHtml();
    }

    default public String baseUrl() {
        return ((LoadHtmlRequest)this).getBaseUrl();
    }

    default public boolean shouldReplaceNavigationEntry() {
        return ((LoadHtmlRequest)this).getReplace();
    }

    public static final class Builder {
        private final LoadHtmlRequest.Builder builder;

        private Builder(String html) {
            this.builder = LoadHtmlRequest.newBuilder().setHtml(html);
        }

        public Builder baseUrl(String baseUrl) {
            Preconditions.checkNotNullEmptyOrBlank(baseUrl);
            this.builder.setBaseUrl(baseUrl);
            return this;
        }

        public Builder shouldReplaceNavigationEntry(boolean shouldReplaceNavigationEntry) {
            this.builder.setReplace(shouldReplaceNavigationEntry);
            return this;
        }

        public LoadHtmlParams build() {
            return this.builder.build();
        }
    }
}

