/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame;

import com.teamdev.jxbrowser.frame.internal.rpc.LoadDataRequest;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.net.internal.rpc.MimeType;

public interface LoadDataParams {
    public static Builder newBuilder(String data) {
        Preconditions.checkNotNull(data);
        return new Builder(data);
    }

    default public String data() {
        return ((LoadDataRequest)this).getData();
    }

    default public String textEncoding() {
        return ((LoadDataRequest)this).getTextEncoding();
    }

    default public String baseUrl() {
        return ((LoadDataRequest)this).getBaseUrl();
    }

    default public com.teamdev.jxbrowser.net.MimeType mimeType() {
        return ((LoadDataRequest)this).getMimeType();
    }

    default public boolean shouldReplaceNavigationEntry() {
        return ((LoadDataRequest)this).getReplace();
    }

    public static final class Builder {
        private final LoadDataRequest.Builder builder;

        private Builder(String data) {
            this.builder = LoadDataRequest.newBuilder().setData(data);
        }

        public Builder textEncoding(String textEncoding) {
            Preconditions.checkNotNullEmptyOrBlank(textEncoding);
            this.builder.setTextEncoding(textEncoding);
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            Preconditions.checkNotNullEmptyOrBlank(baseUrl);
            this.builder.setBaseUrl(baseUrl);
            return this;
        }

        public Builder mimeType(com.teamdev.jxbrowser.net.MimeType mimeType) {
            Preconditions.checkNotNull(mimeType);
            this.builder.setMimeType((MimeType)mimeType);
            return this;
        }

        public Builder shouldReplaceNavigationEntry(boolean shouldReplaceNavigationEntry) {
            this.builder.setReplace(shouldReplaceNavigationEntry);
            return this;
        }

        public LoadDataParams build() {
            return this.builder.build();
        }
    }
}

