/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame;

import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.ui.Color;
import com.teamdev.jxbrowser.ui.FontName;
import com.teamdev.jxbrowser.ui.FontSize;

public final class EditorCommand {
    private final Name name;
    private final String value;

    public static EditorCommand bold() {
        return new EditorCommand(Name.BOLD);
    }

    public static EditorCommand copy() {
        return new EditorCommand(Name.COPY);
    }

    public static EditorCommand cut() {
        return new EditorCommand(Name.CUT);
    }

    public static EditorCommand delete() {
        return new EditorCommand(Name.DELETE);
    }

    public static EditorCommand deleteBackward() {
        return new EditorCommand(Name.DELETE_BACKWARD);
    }

    public static EditorCommand deleteForward() {
        return new EditorCommand(Name.DELETE_FORWARD);
    }

    public static EditorCommand deleteToBeginningOfLine() {
        return new EditorCommand(Name.DELETE_TO_BEGINNING_OF_LINE);
    }

    public static EditorCommand deleteWordBackward() {
        return new EditorCommand(Name.DELETE_WORD_BACKWARD);
    }

    public static EditorCommand deleteWordForward() {
        return new EditorCommand(Name.DELETE_WORD_FORWARD);
    }

    public static EditorCommand insertNewLine() {
        return new EditorCommand(Name.INSERT_NEW_LINE);
    }

    public static EditorCommand insertParagraph() {
        return new EditorCommand(Name.INSERT_PARAGRAPH);
    }

    public static EditorCommand insertTab() {
        return new EditorCommand(Name.INSERT_TAB);
    }

    public static EditorCommand ignoreSpelling() {
        return new EditorCommand(Name.IGNORE_SPELLING);
    }

    public static EditorCommand italic() {
        return new EditorCommand(Name.ITALIC);
    }

    public static EditorCommand movePageUp() {
        return new EditorCommand(Name.MOVE_PAGE_UP);
    }

    public static EditorCommand movePageDown() {
        return new EditorCommand(Name.MOVE_PAGE_DOWN);
    }

    public static EditorCommand moveWordLeft() {
        return new EditorCommand(Name.MOVE_WORD_LEFT);
    }

    public static EditorCommand moveWordLeftAndModifySelection() {
        return new EditorCommand(Name.MOVE_WORD_LEFT_AND_MODIFY_SELECTION);
    }

    public static EditorCommand moveWordRight() {
        return new EditorCommand(Name.MOVE_WORD_RIGHT);
    }

    public static EditorCommand moveWordRightAndModifySelection() {
        return new EditorCommand(Name.MOVE_WORD_RIGHT_AND_MODIFY_SELECTION);
    }

    public static EditorCommand moveToBeginningOfLine() {
        return new EditorCommand(Name.MOVE_TO_BEGINNING_OF_LINE);
    }

    public static EditorCommand moveToBeginningOfLineAndModifySelection() {
        return new EditorCommand(Name.MOVE_TO_BEGINNING_OF_LINE_AND_MODIFY_SELECTION);
    }

    public static EditorCommand moveToEndOfLine() {
        return new EditorCommand(Name.MOVE_TO_END_OF_LINE);
    }

    public static EditorCommand moveToEndOfLineAndModifySelection() {
        return new EditorCommand(Name.MOVE_TO_END_OF_LINE_AND_MODIFY_SELECTION);
    }

    public static EditorCommand paste() {
        return new EditorCommand(Name.PASTE);
    }

    public static EditorCommand redo() {
        return new EditorCommand(Name.REDO);
    }

    public static EditorCommand scrollPageBackward() {
        return new EditorCommand(Name.SCROLL_PAGE_BACKWARD);
    }

    public static EditorCommand scrollPageForward() {
        return new EditorCommand(Name.SCROLL_PAGE_FORWARD);
    }

    public static EditorCommand scrollLineUp() {
        return new EditorCommand(Name.SCROLL_LINE_UP);
    }

    public static EditorCommand scrollLineDown() {
        return new EditorCommand(Name.SCROLL_LINE_DOWN);
    }

    public static EditorCommand scrollToBeginningOfDocument() {
        return new EditorCommand(Name.SCROLL_TO_BEGINNING_OF_DOCUMENT);
    }

    public static EditorCommand scrollToEndOfDocument() {
        return new EditorCommand(Name.SCROLL_TO_END_OF_DOCUMENT);
    }

    public static EditorCommand selectAll() {
        return new EditorCommand(Name.SELECT_ALL);
    }

    public static EditorCommand selectLine() {
        return new EditorCommand(Name.SELECT_LINE);
    }

    public static EditorCommand selectParagraph() {
        return new EditorCommand(Name.SELECT_PARAGRAPH);
    }

    public static EditorCommand selectSentence() {
        return new EditorCommand(Name.SELECT_SENTENCE);
    }

    public static EditorCommand selectWord() {
        return new EditorCommand(Name.SELECT_WORD);
    }

    public static EditorCommand toggleBold() {
        return new EditorCommand(Name.TOGGLE_BOLD);
    }

    public static EditorCommand toggleItalic() {
        return new EditorCommand(Name.TOGGLE_ITALIC);
    }

    public static EditorCommand toggleUnderline() {
        return new EditorCommand(Name.TOGGLE_UNDERLINE);
    }

    public static EditorCommand underline() {
        return new EditorCommand(Name.UNDERLINE);
    }

    public static EditorCommand undo() {
        return new EditorCommand(Name.UNDO);
    }

    public static EditorCommand unselect() {
        return new EditorCommand(Name.UNSELECT);
    }

    public static EditorCommand strikethrough() {
        return new EditorCommand(Name.STRIKETHROUGH);
    }

    public static EditorCommand superscript() {
        return new EditorCommand(Name.SUPERSCRIPT);
    }

    public static EditorCommand subscript() {
        return new EditorCommand(Name.SUBSCRIPT);
    }

    public static EditorCommand removeFormat() {
        return new EditorCommand(Name.REMOVE_FORMAT);
    }

    public static EditorCommand unlink() {
        return new EditorCommand(Name.UNLINK);
    }

    public static EditorCommand justifyCenter() {
        return new EditorCommand(Name.JUSTIFY_CENTER);
    }

    public static EditorCommand justifyFull() {
        return new EditorCommand(Name.JUSTIFY_FULL);
    }

    public static EditorCommand justifyLeft() {
        return new EditorCommand(Name.JUSTIFY_LEFT);
    }

    public static EditorCommand justifyRight() {
        return new EditorCommand(Name.JUSTIFY_RIGHT);
    }

    public static EditorCommand indent() {
        return new EditorCommand(Name.INDENT);
    }

    public static EditorCommand outdent() {
        return new EditorCommand(Name.OUTDENT);
    }

    public static EditorCommand insertOrderedList() {
        return new EditorCommand(Name.INSERT_ORDERED_LIST);
    }

    public static EditorCommand insertUnorderedList() {
        return new EditorCommand(Name.INSERT_UNORDERED_LIST);
    }

    public static EditorCommand backgroundColor(Color color) {
        Preconditions.checkNotNull(color);
        return new EditorCommand(Name.BACKGROUND_COLOR, color.toHexRGBA());
    }

    public static EditorCommand backgroundColor(String colorName) {
        Preconditions.checkNotNullEmptyOrBlank(colorName);
        return new EditorCommand(Name.BACKGROUND_COLOR, colorName);
    }

    public static EditorCommand findText(String text) {
        Preconditions.checkNotNull(text);
        Preconditions.checkArgument(!text.isEmpty());
        return new EditorCommand(Name.FIND_STRING, text);
    }

    public static EditorCommand fontSize(FontSize fontSize) {
        Preconditions.checkNotNull(fontSize);
        return new EditorCommand(Name.FONT_SIZE, String.valueOf(fontSize.value()));
    }

    public static EditorCommand fontName(FontName fontName) {
        Preconditions.checkNotNull(fontName);
        return new EditorCommand(Name.FONT_NAME, fontName.value());
    }

    public static EditorCommand foregroundColor(Color color) {
        Preconditions.checkNotNull(color);
        return new EditorCommand(Name.FOREGROUND_COLOR, color.toHexRGBA());
    }

    public static EditorCommand foregroundColor(String colorName) {
        Preconditions.checkNotNullEmptyOrBlank(colorName);
        return new EditorCommand(Name.FOREGROUND_COLOR, colorName);
    }

    public static EditorCommand insertImage(String imageSrc) {
        Preconditions.checkNotNullEmptyOrBlank(imageSrc);
        return new EditorCommand(Name.INSERT_IMAGE, imageSrc);
    }

    public static EditorCommand insertHtml(String html) {
        Preconditions.checkNotNullEmptyOrBlank(html);
        return new EditorCommand(Name.INSERT_HTML, html);
    }

    public static EditorCommand insertText(String text) {
        Preconditions.checkNotNull(text);
        return new EditorCommand(Name.INSERT_TEXT, text);
    }

    public static EditorCommand createLink(String url) {
        Preconditions.checkNotNullEmptyOrBlank(url);
        return new EditorCommand(Name.CREATE_LINK, url);
    }

    private EditorCommand(Name name) {
        this(name, "");
    }

    private EditorCommand(Name name, String value) {
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(value);
        this.name = name;
        this.value = value;
    }

    public Name name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public static enum Name {
        BOLD("Bold"),
        COPY("Copy"),
        CREATE_LINK("CreateLink"),
        CUT("Cut"),
        DELETE("Delete"),
        DELETE_BACKWARD("DeleteBackward"),
        DELETE_FORWARD("DeleteForward"),
        DELETE_TO_BEGINNING_OF_LINE("DeleteToBeginningOfLine"),
        DELETE_WORD_BACKWARD("DeleteWordBackward"),
        DELETE_WORD_FORWARD("DeleteWordForward"),
        INDENT("Indent"),
        INSERT_NEW_LINE("InsertNewLine"),
        INSERT_ORDERED_LIST("InsertOrderedList"),
        INSERT_PARAGRAPH("InsertParagraph"),
        INSERT_TAB("InsertTab"),
        INSERT_UNORDERED_LIST("InsertUnorderedList"),
        IGNORE_SPELLING("IgnoreSpelling"),
        ITALIC("Italic"),
        JUSTIFY_CENTER("JustifyCenter"),
        JUSTIFY_FULL("JustifyFull"),
        JUSTIFY_LEFT("JustifyLeft"),
        JUSTIFY_RIGHT("JustifyRight"),
        MOVE_PAGE_UP("MovePageUp"),
        MOVE_PAGE_DOWN("MovePageDown"),
        MOVE_WORD_LEFT("MoveWordLeft"),
        MOVE_WORD_LEFT_AND_MODIFY_SELECTION("MoveWordLeftAndModifySelection"),
        MOVE_WORD_RIGHT("MoveWordRight"),
        MOVE_WORD_RIGHT_AND_MODIFY_SELECTION("MoveWordRightAndModifySelection"),
        MOVE_TO_BEGINNING_OF_LINE("MoveToBeginningOfLine"),
        MOVE_TO_BEGINNING_OF_LINE_AND_MODIFY_SELECTION("MoveToBeginningOfLineAndModifySelection"),
        MOVE_TO_END_OF_LINE("MoveToEndOfLine"),
        MOVE_TO_END_OF_LINE_AND_MODIFY_SELECTION("MoveToEndOfLineAndModifySelection"),
        OUTDENT("Outdent"),
        PASTE("Paste"),
        REDO("Redo"),
        REMOVE_FORMAT("RemoveFormat"),
        SCROLL_PAGE_BACKWARD("ScrollPageBackward"),
        SCROLL_PAGE_FORWARD("ScrollPageForward"),
        SCROLL_LINE_UP("ScrollLineUp"),
        SCROLL_LINE_DOWN("ScrollLineDown"),
        SCROLL_TO_BEGINNING_OF_DOCUMENT("ScrollToBeginningOfDocument"),
        SCROLL_TO_END_OF_DOCUMENT("ScrollToEndOfDocument"),
        SELECT_ALL("SelectAll"),
        SELECT_LINE("SelectLine"),
        SELECT_PARAGRAPH("SelectParagraph"),
        SELECT_SENTENCE("SelectSentence"),
        SELECT_WORD("SelectWord"),
        STRIKETHROUGH("Strikethrough"),
        SUBSCRIPT("Subscript"),
        SUPERSCRIPT("Superscript"),
        TOGGLE_BOLD("ToggleBold"),
        TOGGLE_ITALIC("ToggleItalic"),
        TOGGLE_UNDERLINE("ToggleUnderline"),
        UNDERLINE("Underline"),
        UNDO("Undo"),
        UNLINK("Unlink"),
        UNSELECT("Unselect"),
        BACKGROUND_COLOR("BackColor"),
        FIND_STRING("FindString"),
        FONT_SIZE("FontSize"),
        FONT_NAME("FontName"),
        FOREGROUND_COLOR("ForeColor"),
        INSERT_IMAGE("InsertImage"),
        INSERT_HTML("InsertHTML"),
        INSERT_TEXT("InsertText");

        private final String value;

        private Name(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

