/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.event.internal;

import com.teamdev.jxbrowser.event.Event;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.internal.SubscriptionImpl;
import com.teamdev.jxbrowser.internal.ThreadUtil;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class ObservableHelper<T extends Event> {
    private final Map<Class<? extends Event>, Set<Observer>> classToObserversMap = new HashMap<Class<? extends Event>, Set<Observer>>();
    private final Map<Observer, SubscriptionImpl> observerToSubscriptionMap = new HashMap<Observer, SubscriptionImpl>();

    public <E extends T> SubscriptionImpl on(final Class<E> eventClass, final Observer<E> observer) {
        Preconditions.checkNotNull(eventClass);
        Preconditions.checkNotNull(observer);
        if (this.observerToSubscriptionMap.containsKey(observer)) {
            return this.observerToSubscriptionMap.get(observer);
        }
        if (!this.classToObserversMap.containsKey(eventClass)) {
            this.classToObserversMap.put(eventClass, new CopyOnWriteArraySet());
        }
        this.classToObserversMap.get(eventClass).add(observer);
        this.observerToSubscriptionMap.put(observer, new SubscriptionImpl(){

            @Override
            public void unsubscribe() {
                if (this.isUnsubscribed()) {
                    return;
                }
                ObservableHelper.this.observerToSubscriptionMap.remove(observer);
                ((Set)ObservableHelper.this.classToObserversMap.get(eventClass)).remove(observer);
                super.unsubscribe();
            }
        });
        return this.observerToSubscriptionMap.get(observer);
    }

    public <E extends T> void notifyObservers(E event) {
        for (Class<? extends Event> eventClass : this.classToObserversMap.keySet()) {
            if (!eventClass.isAssignableFrom(event.getClass())) continue;
            this.classToObserversMap.get(eventClass).forEach(observer -> {
                try {
                    observer.on(event);
                }
                catch (Exception e) {
                    ThreadUtil.reportException(e);
                    Logger.warn("An exception has been thrown during observers notification", e);
                }
            });
        }
    }
}

