/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.event.internal;

import com.teamdev.jxbrowser.event.Event;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.internal.SubscriptionImpl;
import com.teamdev.jxbrowser.internal.ThreadUtil;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NewObservableHelper {
    private final Map<Observer, SubscriptionImpl> observerSubscriptionMap = new HashMap<Observer, SubscriptionImpl>();

    public <E extends Event> SubscriptionImpl addObserver(final Observer<E> observer) {
        Preconditions.checkNotNull(observer);
        if (!this.observerSubscriptionMap.containsKey(observer)) {
            this.observerSubscriptionMap.put(observer, new SubscriptionImpl(){

                @Override
                public void unsubscribe() {
                    if (!this.isUnsubscribed()) {
                        NewObservableHelper.this.observerSubscriptionMap.remove(observer);
                    }
                    super.unsubscribe();
                }
            });
        }
        return this.observerSubscriptionMap.get(observer);
    }

    public <E extends Event> void notifyObservers(E event) {
        for (Observer observer : this.observers()) {
            try {
                observer.on(event);
            }
            catch (Exception e) {
                ThreadUtil.reportException(e);
                Logger.warn("An exception has been thrown during observers notification", e);
            }
        }
    }

    private List<Observer> observers() {
        return new ArrayList<Observer>(this.observerSubscriptionMap.keySet());
    }

    public boolean hasSubscribers() {
        return !this.observerSubscriptionMap.isEmpty();
    }
}

