/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.event.internal;

import com.teamdev.jxbrowser.event.Event;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.internal.EventSource;
import com.teamdev.jxbrowser.event.internal.SubscriptionImpl;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class EventSourceManager {
    private final Set<EventSource> eventSources = new HashSet<EventSource>();

    public void addEventSource(EventSource eventSource) {
        Preconditions.checkNotNull(eventSource);
        Set<Class<Event>> eventTypes = eventSource.eventTypes();
        for (Class<Event> eventType : eventTypes) {
            if (!this.findEventSource(eventType).isPresent()) continue;
            throw new IllegalArgumentException("An event source for the event " + eventType + " is already registered.");
        }
        this.eventSources.add(eventSource);
    }

    public void removeEventSource(EventSource eventSource) {
        Preconditions.checkNotNull(eventSource);
        this.eventSources.remove(eventSource);
    }

    private <T extends Event> Optional<EventSource> findEventSource(Class<T> eventClass) {
        for (EventSource source : this.eventSources) {
            if (!source.isSourceOf(eventClass)) continue;
            return Optional.of(source);
        }
        return Optional.empty();
    }

    public <T extends Event> SubscriptionImpl on(Class<T> eventClass, Observer<T> observer) {
        Preconditions.checkNotNull(eventClass);
        Preconditions.checkNotNull(observer);
        EventSource eventSource = this.findEventSource(eventClass).orElseThrow(() -> new IllegalArgumentException("No event source found for the event type:" + eventClass));
        return eventSource.on(eventClass, observer);
    }
}

