/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.event.internal;

import com.teamdev.jxbrowser.event.Event;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.internal.EventSource;
import com.teamdev.jxbrowser.event.internal.ObservableHelper;
import com.teamdev.jxbrowser.event.internal.SubscriptionImpl;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CustomEventSource<E extends Event>
implements EventSource<E> {
    private final Set<Class<E>> eventTypes;
    private final ObservableHelper<E> observable;

    @SafeVarargs
    public CustomEventSource(Class<E> ... eventTypes) {
        Preconditions.checkNotNull(eventTypes);
        this.eventTypes = new HashSet<Class<E>>();
        this.observable = new ObservableHelper();
        Collections.addAll(this.eventTypes, eventTypes);
    }

    @Override
    public Set<Class<? extends Event>> eventTypes() {
        return new HashSet<Class<? extends Event>>(this.eventTypes);
    }

    @Override
    public <T extends E> SubscriptionImpl on(Class<T> eventClass, Observer<T> observer) {
        Preconditions.checkNotNull(eventClass);
        Preconditions.checkNotNull(observer);
        return this.observable.on(eventClass, observer);
    }

    @Override
    public <T extends E> void dispatch(T event) {
        Preconditions.checkNotNull(event);
        this.observable.notifyObservers(event);
    }
}

