/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine.internal;

import com.teamdev.jxbrowser.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

final class UnixCommandHelper {
    UnixCommandHelper() {
    }

    Optional<Path> findExecutablePath(String executable) {
        Logger.debug("Finding the {0} executable...", executable);
        Optional<Path> result = this.findExecutablePathByLocations(executable);
        if (result.isPresent()) {
            return result;
        }
        return this.findExecutableByWhichUtil(executable);
    }

    private Optional<Path> findExecutablePathByLocations(String executable) {
        Logger.debug("Finding the {0} executable in PATH...", executable);
        for (String dir : System.getenv("PATH").split(File.pathSeparator)) {
            Path file = Paths.get(dir, executable);
            if (!Files.exists(file, new LinkOption[0]) || !Files.isExecutable(file)) continue;
            Logger.debug("Finding the {0} executable in PATH... [OK]", executable);
            return Optional.of(file);
        }
        Logger.debug("Finding the {0} executable in PATH... [FAIL]", executable);
        return Optional.empty();
    }

    private Optional<Path> findExecutableByWhichUtil(String executable) {
        AtomicReference result = new AtomicReference();
        this.findExecutablePathByLocations("which").ifPresent(path -> {
            Logger.debug("Finding the {0} executable using 'which'...", executable);
            ProcessBuilder processBuilder = new ProcessBuilder(path.toString(), executable);
            try {
                Process process = processBuilder.start();
                int exitCode = process.waitFor();
                if (exitCode == 0) {
                    Logger.debug("Finding the {0} executable using 'which'... [OK]", executable);
                    result.set(Paths.get(this.parseOutput(process.getInputStream()), new String[0]));
                } else {
                    Logger.debug("Finding the {0} executable using 'which'... [FAIL]", executable);
                }
            }
            catch (IOException e) {
                Logger.warn(e, () -> "Finding the " + executable + " executable using 'which'... [FAIL]");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Logger.warn(e, () -> "Finding the " + executable + " executable using 'which'... [FAIL]");
            }
        });
        return Optional.ofNullable(result.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseOutput(InputStream inputStream) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String string = reader.readLine();
            return string;
        }
        finally {
            inputStream.close();
        }
    }
}

