/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine.internal;

import com.teamdev.jxbrowser.engine.MissingDependencyException;
import com.teamdev.jxbrowser.engine.internal.UnixCommandHelper;
import com.teamdev.jxbrowser.internal.ChromiumProcessLinux;
import com.teamdev.jxbrowser.logging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class LinuxDependenciesValidator {
    private final Path dir;

    LinuxDependenciesValidator(Path dir) {
        this.dir = dir;
    }

    void validate() {
        new UnixCommandHelper().findExecutablePath("ldd").ifPresent(lddPath -> {
            Logger.debug("Analyzing dependencies...");
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
            try (Stream<Path> paths = Files.walk(this.dir, new FileVisitOption[0]);){
                Set files = paths.filter(this::isLibrary).filter(path -> !path.endsWith("libawt_helper.so")).collect(Collectors.toSet());
                for (Path file : files) {
                    this.findMissingDependencies((Path)lddPath, file).ifPresent(dependencies -> result.put(file.toFile().getName(), (Set<String>)dependencies));
                }
            }
            catch (IOException e) {
                Logger.warn("Analyzing dependencies... [FAIL]", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Logger.error("Analyzing dependencies... [FAIL]", e);
            }
            if (!result.isEmpty()) {
                throw new MissingDependencyException(result);
            }
        });
    }

    private Optional<Set<String>> findMissingDependencies(Path lddPath, Path libraryPath) throws InterruptedException {
        Path libraryFileName = libraryPath.getFileName();
        Logger.debug("{0}...", libraryFileName);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        this.configureEnvironment(processBuilder);
        processBuilder.command(lddPath.toString(), libraryPath.toAbsolutePath().toString());
        try {
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            return this.processOutput(exitCode, exitCode == 0 ? process.getInputStream() : process.getErrorStream());
        }
        catch (IOException e) {
            Logger.warn(e, () -> libraryFileName + "... [FAIL]");
            return Optional.empty();
        }
    }

    private void configureEnvironment(ProcessBuilder processBuilder) {
        ChromiumProcessLinux.patchLinuxLibraryPath(this.dir.toString(), processBuilder);
        processBuilder.environment().put("LC_ALL", "C");
    }

    private boolean isLibrary(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".so");
    }

    private Optional<Set<String>> processOutput(int exitValue, InputStream inputStream) throws IOException {
        if (exitValue == 0) {
            return this.parseOutput(inputStream);
        }
        this.logError(inputStream);
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Set<String>> parseOutput(InputStream inputStream) throws IOException {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            Optional<Set<String>> optional = this.extractMissingDependencies(lines);
            return optional;
        }
        finally {
            inputStream.close();
        }
    }

    private Optional<Set<String>> extractMissingDependencies(List<String> lines) {
        HashSet result = new HashSet();
        lines.forEach(line -> {
            String libName;
            int pos = line.indexOf("not found");
            if (pos != -1 && !(libName = line.split("=>")[0]).contains("jawt")) {
                result.add(libName.trim());
            }
        });
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    private void logError(InputStream inputStream) throws IOException {
        Scanner scanner = new Scanner(inputStream).useDelimiter("\\A");
        Logger.info(scanner.hasNext() ? scanner.next().trim() : "");
        inputStream.close();
    }
}

