/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine.internal;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.RenderProcesses;
import com.teamdev.jxbrowser.cache.HttpCache;
import com.teamdev.jxbrowser.cache.internal.HttpCacheImpl;
import com.teamdev.jxbrowser.cookie.CookieStore;
import com.teamdev.jxbrowser.cookie.internal.CookieStoreImpl;
import com.teamdev.jxbrowser.download.Downloads;
import com.teamdev.jxbrowser.download.internal.DownloadsImpl;
import com.teamdev.jxbrowser.engine.ChromiumProcessStartupFailureException;
import com.teamdev.jxbrowser.engine.Engine;
import com.teamdev.jxbrowser.engine.EngineInitializationException;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.InvalidLicenseException;
import com.teamdev.jxbrowser.engine.IpcSetupFailureException;
import com.teamdev.jxbrowser.engine.NoLicenseException;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.engine.UserDataDirectoryAlreadyInUseException;
import com.teamdev.jxbrowser.engine.event.EngineClosed;
import com.teamdev.jxbrowser.engine.event.EngineCrashed;
import com.teamdev.jxbrowser.engine.event.EngineEvent;
import com.teamdev.jxbrowser.engine.event.internal.EngineClosedImpl;
import com.teamdev.jxbrowser.engine.internal.LinuxDependenciesValidator;
import com.teamdev.jxbrowser.engine.internal.TempUserDataDirs;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.event.internal.ObservableHelper;
import com.teamdev.jxbrowser.internal.ChromiumExtractor;
import com.teamdev.jxbrowser.internal.ChromiumExtractorException;
import com.teamdev.jxbrowser.internal.ChromiumFiles;
import com.teamdev.jxbrowser.internal.ChromiumProcess;
import com.teamdev.jxbrowser.internal.ChromiumVerifier;
import com.teamdev.jxbrowser.internal.ChromiumVerifiers;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.ExitCode;
import com.teamdev.jxbrowser.internal.FileUtil;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.event.ChromiumProcessStartFailed;
import com.teamdev.jxbrowser.internal.event.ChromiumProcessTerminated;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.ConnectionCreated;
import com.teamdev.jxbrowser.internal.rpc.ConnectionId;
import com.teamdev.jxbrowser.internal.rpc.EngineFactoryStub;
import com.teamdev.jxbrowser.internal.rpc.EngineId;
import com.teamdev.jxbrowser.internal.rpc.EngineStub;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.rpc.RenderingModeValue;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.rpc.transport.ConnectionServer;
import com.teamdev.jxbrowser.internal.rpc.transport.IpcLibrary;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.media.MediaDevices;
import com.teamdev.jxbrowser.media.internal.MediaDevicesImpl;
import com.teamdev.jxbrowser.net.Network;
import com.teamdev.jxbrowser.net.internal.NetworkImpl;
import com.teamdev.jxbrowser.net.proxy.Proxy;
import com.teamdev.jxbrowser.net.proxy.internal.ProxyImpl;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.permission.Permissions;
import com.teamdev.jxbrowser.permission.internal.PermissionsImpl;
import com.teamdev.jxbrowser.plugin.Plugins;
import com.teamdev.jxbrowser.plugin.internal.PluginsImpl;
import com.teamdev.jxbrowser.spellcheck.SpellChecker;
import com.teamdev.jxbrowser.spellcheck.internal.SpellCheckerImpl;
import com.teamdev.jxbrowser.zoom.ZoomLevels;
import com.teamdev.jxbrowser.zoom.internal.ZoomLevelsImpl;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public final class EngineImpl
extends CloseableImpl<EngineImpl>
implements Engine {
    public static final TempUserDataDirs tempUserDataDirs = new TempUserDataDirs();
    static final String EXPIRED_LICENSE_MSG = "This product version is incompatible with the license.";
    static final String EXPIRED_EVAL_LICENSE_MSG = "Your trial period has expired.";
    static final String INVALID_PRODUCT_NAME_MSG = "Invalid product name.";
    static final String INVALID_PRODUCT_BINDING_MSG = "Invalid product binding.";
    static final String INVALID_LICENSE_FORMAT_MSG = "Invalid license format.";
    private static final int IPC_SETUP_TIMEOUT_IN_SECONDS = 600;
    private static final IdMap<EngineId, EngineImpl> engineIdToEngineMap = new IdMap();
    private final EngineId id;
    private final EngineOptions options;
    private final List<BrowserImpl> browsers;
    private final ChromiumProcess chromiumProcess;
    private final RenderProcesses renderProcesses;
    private final Connection connection;
    private final ConnectionServer connectionServer;
    private final NewServiceConnection<EngineStub> rpc;
    private final Subscription chromiumProcessTerminated;
    private final ObservableHelper<EngineEvent> observable;
    private final Lazy<ProxyImpl> proxy;
    private final Lazy<PluginsImpl> plugins;
    private final Lazy<NetworkImpl> network;
    private final Lazy<DownloadsImpl> downloads;
    private final Lazy<HttpCacheImpl> httpCache;
    private final Lazy<ZoomLevelsImpl> zoomLevels;
    private final Lazy<CookieStoreImpl> cookieStore;
    private final Lazy<PermissionsImpl> permissions;
    private final Lazy<MediaDevicesImpl> mediaDevices;
    private final Lazy<SpellCheckerImpl> spellChecker;

    public static Optional<EngineImpl> with(EngineId engineId) {
        Preconditions.checkNotNull(engineId);
        return engineIdToEngineMap.find(engineId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EngineImpl newInstance(EngineOptions options) {
        ChromiumProcessTerminated chromiumProcessTerminated;
        Preconditions.checkNotNull(options);
        Environment.checkEnvironment();
        Path chromiumDir = options.chromiumDir();
        ChromiumFiles chromiumFiles = EngineImpl.extractChromiumBinariesIfNecessary(chromiumDir);
        if (Environment.isLinux()) {
            new LinuxDependenciesValidator(chromiumDir).validate();
        }
        Path userDataDir = options.userDataDir();
        FileUtil.createDirs(userDataDir);
        if (Environment.isMac() || Environment.isLinux()) {
            FileUtil.createDirs(userDataDir.resolve("Memory"));
            FileUtil.createDirs(userDataDir.resolve("Cache"));
        }
        if (ToolkitLibrary.getInstance(chromiumDir).isDirectoryInUse(userDataDir)) {
            throw new UserDataDirectoryAlreadyInUseException(userDataDir);
        }
        String licenseKey = options.licenseKey().orElse("");
        ConnectionServer connectionServer = new ConnectionServer(IpcLibrary.getInstance(chromiumDir), licenseKey, Arrays.asList(Thread.currentThread().getStackTrace()));
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference connectionIdRef = new AtomicReference();
        Subscription connectionCreated = connectionServer.on(ConnectionCreated.class, event -> {
            connectionIdRef.set(event.getConnectionId());
            latch.countDown();
        });
        ChromiumProcess chromiumProcess = ChromiumProcess.create(connectionServer.port(), chromiumDir, chromiumFiles);
        AtomicReference chromiumProcessStartFailedRef = new AtomicReference();
        AtomicReference chromiumProcessTerminatedRef = new AtomicReference();
        chromiumProcess.on(ChromiumProcessStartFailed.class, event -> {
            chromiumProcessStartFailedRef.set(event);
            latch.countDown();
        });
        chromiumProcess.on(ChromiumProcessTerminated.class, event -> {
            chromiumProcessTerminatedRef.set(event);
            latch.countDown();
        });
        chromiumProcess.start(options);
        try {
            if (!latch.await(600L, TimeUnit.SECONDS)) {
                EngineImpl.throwExceptionAndCleanup(connectionServer, new IpcSetupFailureException());
            }
        }
        catch (InterruptedException e) {
            EngineImpl.throwExceptionAndCleanup(connectionServer, new IpcSetupFailureException("The current thread has been interrupted.", e));
        }
        finally {
            connectionCreated.unsubscribe();
        }
        if (chromiumProcessStartFailedRef.get() != null) {
            EngineImpl.throwExceptionAndCleanup(connectionServer, new ChromiumProcessStartupFailureException());
        }
        if ((chromiumProcessTerminated = (ChromiumProcessTerminated)chromiumProcessTerminatedRef.get()) != null) {
            EngineImpl.throwExceptionAndCleanup(connectionServer, chromiumProcessTerminated.exitCode());
        }
        Connection connection = connectionServer.awaitConnection((ConnectionId)connectionIdRef.get()).orElseThrow(IllegalStateException::new);
        NewServiceConnection<EngineFactoryStub> rpc = new NewServiceConnection<EngineFactoryStub>(ProtobufUtil.empty(), connection, EngineFactoryStub::new);
        EngineId engineId = (EngineId)rpc.invoke(rpc.stub()::createEngine, RenderingModeValue.newBuilder().setRenderingMode(options.renderingMode() == RenderingMode.OFF_SCREEN ? com.teamdev.jxbrowser.internal.rpc.RenderingMode.OFF_SCREEN : com.teamdev.jxbrowser.internal.rpc.RenderingMode.HARDWARE_ACCELERATED).build());
        EngineImpl engine = new EngineImpl(connection, connectionServer, engineId, options, chromiumProcess);
        engine.on(EngineClosed.class, event -> EngineImpl.cleanUserDataDir(event.engine()));
        engine.on(EngineCrashed.class, event -> EngineImpl.cleanUserDataDir(event.engine()));
        return engine;
    }

    private EngineImpl(Connection connection, ConnectionServer connectionServer, EngineId engineId, EngineOptions options, ChromiumProcess chromiumProcess) {
        Preconditions.checkNotNull(connection);
        Preconditions.checkNotNull(connectionServer);
        Preconditions.checkNotNull(engineId);
        Preconditions.checkNotNull(options);
        Preconditions.checkNotNull(chromiumProcess);
        this.id = engineId;
        this.options = options;
        this.connection = connection;
        this.chromiumProcess = chromiumProcess;
        this.connectionServer = connectionServer;
        this.renderProcesses = new RenderProcesses();
        this.observable = new ObservableHelper();
        this.browsers = new CopyOnWriteArrayList<BrowserImpl>();
        this.proxy = new Lazy<ProxyImpl>(() -> new ProxyImpl(this));
        this.plugins = new Lazy<PluginsImpl>(() -> new PluginsImpl(this));
        this.network = new Lazy<NetworkImpl>(() -> new NetworkImpl(this));
        this.downloads = new Lazy<DownloadsImpl>(() -> new DownloadsImpl(this));
        this.httpCache = new Lazy<HttpCacheImpl>(() -> new HttpCacheImpl(this));
        this.zoomLevels = new Lazy<ZoomLevelsImpl>(() -> new ZoomLevelsImpl(this));
        this.cookieStore = new Lazy<CookieStoreImpl>(() -> new CookieStoreImpl(this));
        this.permissions = new Lazy<PermissionsImpl>(() -> new PermissionsImpl(this));
        this.mediaDevices = new Lazy<MediaDevicesImpl>(() -> new MediaDevicesImpl(this));
        this.spellChecker = new Lazy<SpellCheckerImpl>(() -> new SpellCheckerImpl(this));
        this.rpc = new NewServiceConnection<EngineStub>(this.id, connection, EngineStub::new);
        this.chromiumProcessTerminated = chromiumProcess.on(ChromiumProcessTerminated.class, event -> new Thread(this::close).start());
        engineIdToEngineMap.put(this.id, this);
    }

    private static void throwExceptionAndCleanup(ConnectionServer connectionServer, EngineInitializationException exception) {
        connectionServer.close();
        throw exception;
    }

    private static void throwExceptionAndCleanup(ConnectionServer connectionServer, ExitCode exitCode) {
        if (exitCode.equals(ExitCode.NO_LICENSE)) {
            EngineImpl.throwExceptionAndCleanup(connectionServer, new NoLicenseException());
        }
        if (exitCode.equals(ExitCode.EXPIRED_EVALUATION_LICENSE)) {
            EngineImpl.throwExceptionAndCleanup(connectionServer, new InvalidLicenseException(EXPIRED_EVAL_LICENSE_MSG));
        }
        if (exitCode.equals(ExitCode.EXPIRED_LICENSE)) {
            EngineImpl.throwExceptionAndCleanup(connectionServer, new InvalidLicenseException(EXPIRED_LICENSE_MSG));
        }
        if (exitCode.equals(ExitCode.INVALID_LICENSE_PRODUCT_NAME)) {
            EngineImpl.throwExceptionAndCleanup(connectionServer, new InvalidLicenseException(INVALID_PRODUCT_NAME_MSG));
        }
        if (exitCode.equals(ExitCode.INVALID_LICENSE_PRODUCT_BINDING)) {
            EngineImpl.throwExceptionAndCleanup(connectionServer, new InvalidLicenseException(INVALID_PRODUCT_BINDING_MSG));
        }
        if (exitCode.equals(ExitCode.INVALID_LICENSE_CONTENT)) {
            EngineImpl.throwExceptionAndCleanup(connectionServer, new InvalidLicenseException(INVALID_LICENSE_FORMAT_MSG));
        }
        EngineImpl.throwExceptionAndCleanup(connectionServer, new ChromiumProcessStartupFailureException(exitCode));
    }

    private static void cleanUserDataDir(Engine engine) {
        Path userDataDir = engine.options().userDataDir();
        if (tempUserDataDirs.list().contains(userDataDir)) {
            FileUtil.deleteDir(tempUserDataDirs.remove(userDataDir));
        }
    }

    public Connection connection() {
        return this.connection;
    }

    @Nullable
    private static ChromiumFiles extractChromiumBinariesIfNecessary(Path chromiumDir) {
        List<ChromiumVerifier> verifiers = ChromiumVerifiers.list();
        if (verifiers.isEmpty()) {
            Logger.debug("No verifiers found. Skipping verification and extraction...");
            return null;
        }
        Logger.debug("Verifying Chromium binaries...");
        Optional<ChromiumFiles> chromiumFiles = EngineImpl.verifyChromiumBinaries(chromiumDir);
        return chromiumFiles.orElseGet(() -> {
            Logger.debug("Verifying Chromium binaries... [FAIL]");
            ChromiumExtractor.extract(chromiumDir);
            Logger.debug("Verifying Chromium binaries...");
            return EngineImpl.verifyChromiumBinaries(chromiumDir).orElseThrow(() -> new ChromiumExtractorException("Failed to verify the extracted Chromium binaries."));
        });
    }

    private static Optional<ChromiumFiles> verifyChromiumBinaries(Path chromiumDir) {
        List<ChromiumVerifier> verifiers = ChromiumVerifiers.list();
        for (ChromiumVerifier verifier : verifiers) {
            if (!verifier.verify(chromiumDir)) continue;
            Logger.debug("Verifying Chromium binaries... [OK]");
            return Optional.of(verifier.files());
        }
        return Optional.empty();
    }

    public ConnectionServer connectionServer() {
        return this.connectionServer;
    }

    public RenderProcesses renderProcesses() {
        return this.renderProcesses;
    }

    public EngineId id() {
        return this.id;
    }

    @Override
    public EngineOptions options() {
        return this.options;
    }

    @Override
    public Browser newBrowser() {
        this.checkNotClosed();
        BrowserId browserId = (BrowserId)this.rpc.invoke(this.rpc.stub()::createBrowser, ProtobufUtil.empty());
        BrowserImpl browser = new BrowserImpl(this.connection, this, browserId);
        browser.navigation().loadUrlAndWait("about:blank");
        return browser;
    }

    public void addBrowser(BrowserImpl browser) {
        if (!this.browsers.contains(browser)) {
            this.browsers.add(browser);
        }
    }

    public void removeBrowser(BrowserImpl browser) {
        this.browsers.remove(browser);
    }

    @Override
    public List<Browser> browsers() {
        return Collections.unmodifiableList(this.browsers);
    }

    @Override
    public ZoomLevels zoomLevels() {
        return this.zoomLevels.get();
    }

    @Override
    public Proxy proxy() {
        return this.proxy.get();
    }

    @Override
    public Network network() {
        return this.network.get();
    }

    @Override
    public SpellChecker spellChecker() {
        return this.spellChecker.get();
    }

    @Override
    public CookieStore cookieStore() {
        return this.cookieStore.get();
    }

    @Override
    public HttpCache httpCache() {
        return this.httpCache.get();
    }

    @Override
    public MediaDevices mediaDevices() {
        return this.mediaDevices.get();
    }

    @Override
    public Plugins plugins() {
        return this.plugins.get();
    }

    @Override
    public Downloads downloads() {
        return this.downloads.get();
    }

    @Override
    public Permissions permissions() {
        return this.permissions.get();
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        Logger.debug("Closing engine...");
        this.chromiumProcessTerminated.unsubscribe();
        this.browsers.forEach(BrowserImpl::close);
        if (!this.rpc.isClosed()) {
            this.rpc.invokeAsync(this.rpc.stub()::close, this.id);
        }
        this.awaitProcessTermination();
        this.connectionServer.close();
        this.renderProcesses.close();
        EngineImpl.closeIfNecessary(this.proxy);
        EngineImpl.closeIfNecessary(this.plugins);
        EngineImpl.closeIfNecessary(this.network);
        EngineImpl.closeIfNecessary(this.httpCache);
        EngineImpl.closeIfNecessary(this.downloads);
        EngineImpl.closeIfNecessary(this.zoomLevels);
        EngineImpl.closeIfNecessary(this.cookieStore);
        EngineImpl.closeIfNecessary(this.mediaDevices);
        EngineImpl.closeIfNecessary(this.spellChecker);
        engineIdToEngineMap.remove(this.id);
        super.close();
        Logger.debug("Closing engine... [OK]");
    }

    private void awaitProcessTermination() {
        Logger.debug("Awaiting process termination...");
        this.chromiumProcess.close();
        Logger.debug("Awaiting process termination... [OK]");
        final ExitCode exitCode = this.chromiumProcess.exitCode();
        if (exitCode.equals(ExitCode.OK)) {
            Logger.debug("Chromium process exit code: {0}", exitCode);
            this.observable.notifyObservers(new EngineClosedImpl(this));
        } else {
            Logger.error("Chromium process exit code: {0}", exitCode);
            this.observable.notifyObservers(new EngineCrashed(){

                @Override
                public int exitCode() {
                    return exitCode.value();
                }

                @Override
                public Engine engine() {
                    return EngineImpl.this;
                }
            });
        }
    }

    @Override
    public <E extends EngineEvent> Subscription on(Class<E> eventClass, Observer<E> listener) {
        return this.observable.on(eventClass, listener);
    }

    static {
        Environment.traceEnvironment();
    }
}

