/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine;

import com.teamdev.jxbrowser.internal.ChromiumLanguage;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.os.Environment;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.Optional;

public enum Language {
    AMHARIC(ChromiumLanguage.of("am")),
    AFRIKAANS(ChromiumLanguage.of("ar")),
    BULGARIAN(ChromiumLanguage.of("bg")),
    BENGALI(ChromiumLanguage.of("bn")),
    CATALAN(ChromiumLanguage.of("ca")),
    CZECH(ChromiumLanguage.of("cs")),
    DANISH(ChromiumLanguage.of("da")),
    GERMAN(ChromiumLanguage.of("de")),
    GREEK(ChromiumLanguage.of("el")),
    ENGLISH_US(Environment.isMac() ? ChromiumLanguage.of("en") : ChromiumLanguage.of("en", "us")),
    ENGLISH_UK(ChromiumLanguage.of("en", "gb")),
    SPANISH_LATIN_AMERICA(ChromiumLanguage.of("es", "419")),
    SPANISH_SPAIN(ChromiumLanguage.of("es")),
    ESTONIAN(ChromiumLanguage.of("et")),
    PERSIAN(ChromiumLanguage.of("fa")),
    FINNISH(ChromiumLanguage.of("fi")),
    FILIPINO(ChromiumLanguage.of("fil")),
    FRENCH(ChromiumLanguage.of("fr")),
    GUJARATI(ChromiumLanguage.of("gu")),
    HEBREW(ChromiumLanguage.of("he")),
    HINDI(ChromiumLanguage.of("hi")),
    CROATIAN(ChromiumLanguage.of("hr")),
    HUNGARIAN(ChromiumLanguage.of("hu")),
    INDONESIAN(ChromiumLanguage.of("id")),
    ITALIAN(ChromiumLanguage.of("it")),
    JAPANESE(ChromiumLanguage.of("ja")),
    KANNADA(ChromiumLanguage.of("kn")),
    KOREAN(ChromiumLanguage.of("ko")),
    LITHUANIAN(ChromiumLanguage.of("lt")),
    LATVIAN(ChromiumLanguage.of("lv")),
    MALAYALAM(ChromiumLanguage.of("ml")),
    MARATHI(ChromiumLanguage.of("mr")),
    MALAY(ChromiumLanguage.of("ms")),
    NORWEGIAN(ChromiumLanguage.of("nb")),
    DUTCH(ChromiumLanguage.of("nl")),
    POLISH(ChromiumLanguage.of("pl")),
    PORTUGUESE_BRAZIL(ChromiumLanguage.of("pt", "br")),
    PORTUGUESE_PORTUGAL(ChromiumLanguage.of("pt", "pt")),
    ROMANIAN(ChromiumLanguage.of("ro")),
    RUSSIAN(ChromiumLanguage.of("ru")),
    SLOVAK(ChromiumLanguage.of("sk")),
    SLOVENIAN(ChromiumLanguage.of("sl")),
    SERBIAN(ChromiumLanguage.of("sr")),
    SWEDISH(ChromiumLanguage.of("sv")),
    SWAHILI(ChromiumLanguage.of("sw")),
    TAMIL(ChromiumLanguage.of("ta")),
    TELUGU(ChromiumLanguage.of("te")),
    THAI(ChromiumLanguage.of("th")),
    TURKISH(ChromiumLanguage.of("tr")),
    UKRAINIAN(ChromiumLanguage.of("uk")),
    VIETNAMESE(ChromiumLanguage.of("vi")),
    CHINESE(ChromiumLanguage.of("zh", "cn")),
    CHINESE_TAIWAN(ChromiumLanguage.of("zh", "tw"));

    private final ChromiumLanguage chromiumLanguage;

    public static Optional<Language> of(Locale locale) {
        return Language.of(locale.getLanguage(), locale.getCountry());
    }

    public static Optional<Language> of(String language, String country) {
        Preconditions.checkNotNull(language);
        Preconditions.checkNotNull(country);
        ArrayList<ChromiumLanguage> fittedChromiumLanguages = new ArrayList<ChromiumLanguage>();
        for (Language localLanguage : Language.values()) {
            ChromiumLanguage chromiumLanguage2 = localLanguage.chromiumLanguage;
            if (!chromiumLanguage2.code().equalsIgnoreCase(language)) continue;
            fittedChromiumLanguages.add(chromiumLanguage2);
            if (!chromiumLanguage2.country().orElse("").equalsIgnoreCase(country)) continue;
            return Optional.of(localLanguage);
        }
        if (!fittedChromiumLanguages.isEmpty()) {
            fittedChromiumLanguages.sort(Comparator.comparing(chromiumLanguage -> chromiumLanguage.country().orElse("")));
            for (Language localLanguage : Language.values()) {
                if (!((ChromiumLanguage)fittedChromiumLanguages.get(0)).equals(localLanguage.chromiumLanguage)) continue;
                return Optional.of(localLanguage);
            }
        }
        return Optional.empty();
    }

    private Language(ChromiumLanguage chromiumLanguage) {
        this.chromiumLanguage = Preconditions.checkNotNull(chromiumLanguage);
    }

    public String toString() {
        return this.chromiumLanguage.toString();
    }
}

