/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.engine.Language;
import com.teamdev.jxbrowser.engine.PasswordStore;
import com.teamdev.jxbrowser.engine.ProprietaryFeature;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.os.Environment;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public final class EngineOptions {
    private final Path userDataDir;
    private final Path chromiumDir;
    private final String licenseKey;
    private final String userAgent;
    private final String googleApiKey;
    private final String googleDefaultClientId;
    private final String googleDefaultClientSecret;
    private final Path ppapiFlashPath;
    private final String ppapiFlashVersion;
    private final Long diskCacheSize;
    private final Integer remoteDebuggingPort;
    private final boolean incognitoEnabled;
    private final boolean sandboxDisabled;
    private final boolean webSecurityDisabled;
    private final boolean fileAccessFromFilesAllowed;
    private final boolean autoplayEnabled;
    private final boolean gpuDisabled;
    private final Language language;
    private final RenderingMode renderingMode;
    private final PasswordStore passwordStore;
    private final List<String> switches;
    private final List<String> secureOriginWhiteList;
    private final boolean touchMenuDisabled;
    private final Set<ProprietaryFeature> proprietaryFeatures;

    public static Builder newBuilder(RenderingMode renderingMode) {
        Preconditions.checkNotNull(renderingMode);
        return new Builder(renderingMode);
    }

    private EngineOptions(Builder builder) {
        this.userDataDir = builder.userDataDir;
        this.chromiumDir = builder.chromiumDir;
        this.licenseKey = builder.licenseKey;
        this.userAgent = builder.userAgent;
        this.googleApiKey = builder.googleApiKey;
        this.googleDefaultClientId = builder.googleDefaultClientId;
        this.googleDefaultClientSecret = builder.googleDefaultClientSecret;
        this.ppapiFlashPath = builder.ppapiFlashPath;
        this.ppapiFlashVersion = builder.ppapiFlashVersion;
        this.diskCacheSize = builder.diskCacheSize;
        this.remoteDebuggingPort = builder.remoteDebuggingPort;
        this.incognitoEnabled = builder.incognitoEnabled;
        this.sandboxDisabled = builder.sandboxDisabled;
        this.webSecurityDisabled = builder.webSecurityDisabled;
        this.fileAccessFromFilesAllowed = builder.fileAccessFromFilesAllowed;
        this.autoplayEnabled = builder.autoplayEnabled;
        this.gpuDisabled = builder.gpuDisabled;
        this.language = builder.language;
        this.renderingMode = builder.renderingMode;
        this.passwordStore = builder.passwordStore;
        this.switches = Collections.unmodifiableList(builder.switches);
        this.secureOriginWhiteList = Collections.unmodifiableList(builder.secureOriginWhiteList);
        this.touchMenuDisabled = builder.touchMenuDisabled;
        this.proprietaryFeatures = Collections.unmodifiableSet(builder.proprietaryFeatures);
    }

    public Path userDataDir() {
        return this.userDataDir;
    }

    public Path chromiumDir() {
        return this.chromiumDir;
    }

    public Optional<String> licenseKey() {
        return Optional.ofNullable(this.licenseKey);
    }

    public Optional<String> userAgent() {
        return Optional.ofNullable(this.userAgent);
    }

    public Optional<String> googleApiKey() {
        return Optional.ofNullable(this.googleApiKey);
    }

    public Optional<String> googleDefaultClientId() {
        return Optional.ofNullable(this.googleDefaultClientId);
    }

    public Optional<String> googleDefaultClientSecret() {
        return Optional.ofNullable(this.googleDefaultClientSecret);
    }

    public Optional<Path> ppapiFlashPath() {
        return Optional.ofNullable(this.ppapiFlashPath);
    }

    public Optional<String> ppapiFlashVersion() {
        return Optional.ofNullable(this.ppapiFlashVersion);
    }

    public RenderingMode renderingMode() {
        return this.renderingMode;
    }

    public Language language() {
        return this.language;
    }

    public Optional<Integer> remoteDebuggingPort() {
        return Optional.ofNullable(this.remoteDebuggingPort);
    }

    public Optional<PasswordStore> passwordStore() {
        return Optional.ofNullable(this.passwordStore);
    }

    public Optional<Long> diskCacheSize() {
        return Optional.ofNullable(this.diskCacheSize);
    }

    public boolean isIncognitoEnabled() {
        return this.incognitoEnabled;
    }

    public boolean isSandboxDisabled() {
        return this.sandboxDisabled;
    }

    public boolean isWebSecurityDisabled() {
        return this.webSecurityDisabled;
    }

    public boolean isFileAccessFromFilesAllowed() {
        return this.fileAccessFromFilesAllowed;
    }

    public boolean isAutoplayEnabled() {
        return this.autoplayEnabled;
    }

    public boolean isGpuDisabled() {
        return this.gpuDisabled;
    }

    public boolean isTouchMenuDisabled() {
        return this.touchMenuDisabled;
    }

    public boolean isProprietaryFeatureEnabled(ProprietaryFeature feature) {
        return this.proprietaryFeatures.contains((Object)feature);
    }

    @Immutable
    public List<String> secureOriginWhiteList() {
        return this.secureOriginWhiteList;
    }

    @Immutable
    public List<String> switches() {
        return this.switches;
    }

    public static final class Builder {
        private final RenderingMode renderingMode;
        private final List<String> switches;
        private final List<String> secureOriginWhiteList;
        private Path userDataDir;
        private Path chromiumDir;
        private String licenseKey;
        private String userAgent;
        private String googleApiKey;
        private String googleDefaultClientId;
        private String googleDefaultClientSecret;
        private Path ppapiFlashPath;
        private String ppapiFlashVersion;
        private Long diskCacheSize;
        private boolean gpuDisabled;
        private boolean incognitoEnabled;
        private boolean sandboxDisabled;
        private boolean webSecurityDisabled;
        private boolean fileAccessFromFilesAllowed;
        private boolean autoplayEnabled;
        private Language language;
        private PasswordStore passwordStore;
        private Integer remoteDebuggingPort;
        private boolean touchMenuDisabled;
        private Set<ProprietaryFeature> proprietaryFeatures;

        private Builder(RenderingMode renderingMode) {
            this.renderingMode = renderingMode;
            this.chromiumDir = Paths.get(System.getProperty("jxbrowser.chromium.dir", Environment.defaultChromiumDir().toString()), new String[0]);
            this.userDataDir = EngineImpl.tempUserDataDirs.add(Environment.userTempDir().resolve("UserData").resolve(UUID.randomUUID().toString()));
            this.licenseKey = System.getProperty("jxbrowser.license.key");
            this.language = Language.of(Locale.getDefault()).orElse(Language.ENGLISH_US);
            this.switches = new ArrayList<String>();
            this.secureOriginWhiteList = new ArrayList<String>();
            this.proprietaryFeatures = new HashSet<ProprietaryFeature>();
        }

        public Builder userDataDir(Path userDataDir) {
            Preconditions.checkNotNull(userDataDir);
            this.userDataDir = userDataDir;
            return this;
        }

        public Builder chromiumDir(Path chromiumDir) {
            Preconditions.checkNotNull(chromiumDir);
            this.chromiumDir = chromiumDir;
            return this;
        }

        public Builder licenseKey(String licenseKey) {
            Preconditions.checkNotNullEmptyOrBlank(licenseKey);
            this.licenseKey = licenseKey;
            return this;
        }

        public Builder userAgent(String userAgent) {
            Preconditions.checkNotNullEmptyOrBlank(userAgent);
            this.userAgent = userAgent;
            return this;
        }

        public Builder googleApiKey(String googleApiKey) {
            Preconditions.checkNotNullEmptyOrBlank(googleApiKey);
            this.googleApiKey = googleApiKey;
            return this;
        }

        public Builder googleDefaultClientId(String googleDefaultClientId) {
            Preconditions.checkNotNullEmptyOrBlank(googleDefaultClientId);
            this.googleDefaultClientId = googleDefaultClientId;
            return this;
        }

        public Builder googleDefaultClientSecret(String googleDefaultClientSecret) {
            Preconditions.checkNotNullEmptyOrBlank(googleDefaultClientSecret);
            this.googleDefaultClientSecret = googleDefaultClientSecret;
            return this;
        }

        public Builder ppapiFlashPath(Path ppapiFlashPath) {
            Preconditions.checkNotNull(ppapiFlashPath);
            this.ppapiFlashPath = ppapiFlashPath;
            return this;
        }

        public Builder ppapiFlashVersion(String ppapiFlashVersion) {
            Preconditions.checkNotNullEmptyOrBlank(ppapiFlashVersion);
            this.ppapiFlashVersion = ppapiFlashVersion;
            return this;
        }

        public Builder language(Language language) {
            Preconditions.checkNotNull(language);
            this.language = language;
            return this;
        }

        public Builder remoteDebuggingPort(int remoteDebuggingPort) {
            Preconditions.checkArgument(remoteDebuggingPort > 0);
            this.remoteDebuggingPort = remoteDebuggingPort;
            return this;
        }

        public Builder passwordStore(PasswordStore passwordStore) {
            Preconditions.checkNotNull(passwordStore);
            this.passwordStore = passwordStore;
            return this;
        }

        public Builder diskCacheSize(long diskCacheSize) {
            Preconditions.checkArgument(diskCacheSize > 0L);
            this.diskCacheSize = diskCacheSize;
            return this;
        }

        public Builder disableTouchMenu() {
            this.touchMenuDisabled = true;
            return this;
        }

        public Builder enableIncognito() {
            this.incognitoEnabled = true;
            return this;
        }

        public Builder disableSandbox() {
            this.sandboxDisabled = true;
            return this;
        }

        public Builder disableWebSecurity() {
            this.webSecurityDisabled = true;
            return this;
        }

        public Builder allowFileAccessFromFiles() {
            this.fileAccessFromFilesAllowed = true;
            return this;
        }

        public Builder enableAutoplay() {
            this.autoplayEnabled = true;
            return this;
        }

        public Builder disableGpu() {
            this.gpuDisabled = true;
            return this;
        }

        public Builder treatInsecureOriginAsSecure(String ... origins) {
            Preconditions.checkNotNull(origins);
            this.secureOriginWhiteList.clear();
            this.secureOriginWhiteList.addAll(Arrays.asList(origins));
            return this;
        }

        public Builder addSwitch(String commandLineSwitch) {
            Preconditions.checkNotNullEmptyOrBlank(commandLineSwitch);
            this.switches.add(commandLineSwitch);
            return this;
        }

        public Builder enableProprietaryFeature(ProprietaryFeature feature) {
            Preconditions.checkNotNull(feature);
            this.proprietaryFeatures.add(feature);
            return this;
        }

        public EngineOptions build() {
            return new EngineOptions(this);
        }
    }
}

