/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.download.internal;

import com.teamdev.jxbrowser.download.Download;
import com.teamdev.jxbrowser.download.Downloads;
import com.teamdev.jxbrowser.download.callback.DownloadsCallback;
import com.teamdev.jxbrowser.download.internal.DownloadImpl;
import com.teamdev.jxbrowser.download.internal.rpc.DownloadsStub;
import com.teamdev.jxbrowser.download.internal.rpc.StartDownload;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public final class DownloadsImpl
extends CloseableImpl
implements Downloads {
    private final EngineImpl engine;
    private final List<DownloadImpl> downloads;
    private final NewServiceConnection<DownloadsStub> rpc;

    public DownloadsImpl(EngineImpl engine) {
        Preconditions.checkNotNull(engine);
        this.engine = engine;
        this.downloads = new CopyOnWriteArrayList<DownloadImpl>();
        this.rpc = new NewServiceConnection<DownloadsStub>(engine.id(), engine.connection(), DownloadsStub::new);
        this.rpc.setPreProcessor(StartDownload.class, message -> {
            StartDownload.Request request = message.getRequest();
            this.downloads.add(new DownloadImpl(this, request.getDownloadId(), request.getDownloadTarget()));
        });
    }

    public EngineImpl engine() {
        return this.engine;
    }

    @Override
    public void close() {
        this.downloads.forEach(DownloadImpl::close);
        super.close();
    }

    @Override
    public <C extends DownloadsCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((DownloadsCallback)this.rpc.set(callbackClass, callback));
    }

    @Override
    public <C extends DownloadsCallback> Optional<C> get(Class<C> callbackClass) {
        return this.rpc.get(callbackClass);
    }

    @Override
    public <C extends DownloadsCallback> C remove(Class<C> callbackClass) {
        return (C)((DownloadsCallback)this.rpc.remove(callbackClass));
    }

    @Override
    public List<Download> list() {
        return Collections.unmodifiableList(this.downloads);
    }
}

