/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.download.internal;

import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.download.Download;
import com.teamdev.jxbrowser.download.DownloadState;
import com.teamdev.jxbrowser.download.DownloadTarget;
import com.teamdev.jxbrowser.download.event.DownloadEvent;
import com.teamdev.jxbrowser.download.internal.DownloadsImpl;
import com.teamdev.jxbrowser.download.internal.rpc.DownloadStateValue;
import com.teamdev.jxbrowser.download.internal.rpc.DownloadsStub;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.IdMap;
import com.teamdev.jxbrowser.internal.rpc.DownloadId;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import java.util.Optional;

public final class DownloadImpl
extends CloseableImpl
implements Download {
    private static final IdMap<DownloadId, DownloadImpl> downloadIdToDownloadMap = new IdMap();
    private final DownloadId id;
    private final DownloadTarget target;
    private final NewServiceConnection<DownloadsStub> rpc;

    public static Optional<DownloadImpl> with(DownloadId id) {
        Preconditions.checkNotNull(id);
        return downloadIdToDownloadMap.find(id);
    }

    DownloadImpl(DownloadsImpl downloads, DownloadId downloadId, DownloadTarget target) {
        this.id = downloadId;
        this.target = target;
        this.rpc = new NewServiceConnection<DownloadsStub>(downloadId, downloads.engine().connection(), DownloadsStub::new);
        downloadIdToDownloadMap.put(downloadId, this);
    }

    @Override
    public void close() {
        downloadIdToDownloadMap.remove(this.id);
        super.close();
    }

    @Override
    public DownloadTarget target() {
        return this.target;
    }

    @Override
    public DownloadState state() {
        this.checkNotClosed();
        return ((DownloadStateValue)this.rpc.invoke(this.rpc.stub()::getState, this.id)).getValue();
    }

    @Override
    public boolean isPaused() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isPaused, this.id)).getValue();
    }

    @Override
    public void pause() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::pause, this.id);
    }

    @Override
    public void resume() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::resume, this.id);
    }

    @Override
    public void cancel() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::cancel, this.id);
    }

    @Override
    public <E extends DownloadEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }
}

