/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.download.callback;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.download.Download;
import com.teamdev.jxbrowser.download.callback.DownloadsAsyncCallback;
import com.teamdev.jxbrowser.download.internal.DownloadImpl;
import com.teamdev.jxbrowser.download.internal.rpc.StartDownload;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.internal.rpc.FilePath;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;

public interface StartDownloadCallback
extends DownloadsAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<StartDownload.Response> {
        public Action(Consumer<StartDownload.Response> consumer) {
            super(consumer);
        }

        public void download(Path destFilePath) {
            Preconditions.checkNotNull(destFilePath);
            this.send(StartDownload.Response.newBuilder().setSaveTo(FilePath.newBuilder().setValue(destFilePath.toAbsolutePath().toString()).build()).build());
        }

        public void cancel() {
            this.send(StartDownload.Response.newBuilder().setCancel(ProtobufUtil.empty()).build());
        }
    }

    public static interface Params {
        default public Download download() {
            return DownloadImpl.with(((StartDownload.Request)this).getDownloadId()).orElseThrow(IllegalStateException::new);
        }

        default public Optional<Browser> browser() {
            return Optional.ofNullable(BrowserImpl.with(((StartDownload.Request)this).getBrowserId()).orElse(null));
        }

        default public Optional<Frame> frame() {
            return Optional.ofNullable(FrameImpl.with(((StartDownload.Request)this).getFrameId()).orElse(null));
        }
    }
}

