/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.internal;

import com.teamdev.jxbrowser.dom.Document;
import com.teamdev.jxbrowser.dom.FrameElement;
import com.teamdev.jxbrowser.dom.internal.DomContext;
import com.teamdev.jxbrowser.dom.internal.ElementImpl;
import com.teamdev.jxbrowser.dom.internal.rpc.FrameElementStub;
import com.teamdev.jxbrowser.dom.internal.rpc.FrameNodeInfo;
import com.teamdev.jxbrowser.dom.internal.rpc.GetContentDocumentRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import java.util.Optional;

final class FrameElementImpl
extends ElementImpl
implements FrameElement {
    private final NewServiceConnection<FrameElementStub> rpc;

    FrameElementImpl(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        super(connection, domContext, nodeInfo);
        this.rpc = new NewServiceConnection<FrameElementStub>(nodeInfo, connection, FrameElementStub::new);
    }

    @Override
    public Optional<Document> contentDocument() {
        this.checkNotClosed();
        FrameNodeInfo response = (FrameNodeInfo)this.rpc.invoke(this.rpc.stub()::getContentDocument, GetContentDocumentRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build());
        if (response.getNodeInfo().getNodeId().getValue() != 0) {
            return FrameImpl.with(response.getFrameId()).map(frame -> {
                DomContext domContext = frame.domContext();
                return Optional.of(domContext.toDocument(response.getNodeInfo()));
            }).orElse(Optional.empty());
        }
        return Optional.empty();
    }
}

